#!usr/bin/perl -w

## Written by Sarah B. Carey

## this script takes in pruned trees (from prune_tree.py) that have been renamed
## (from paml_header_prep.pl) and prints labeled trees for PAML.
## The script as is will write a tree with no labels (all branches evolve the same)
## a tree with C. purpureus GG1 and R40 evolving differently than the rest of the tree
## (1 label) and a tree with C. purpureus GG1 and R40 evolving differently from each 
## other and the rest of the tree (2 labels)



@filearray = glob("cluster*\.paml.tre");
for $file(@filearray)
{
    if ($file =~ m/cluster(\d+)\.paml.tre/)
    {
	$filenum = $1;
	}

$tree_file = "cluster$filenum\.paml.tre";

open IN, "<$tree_file" or die "Tree not working\n";

open OUT, ">cluster$filenum.nolabel.tre";
open OUT2, ">cluster$filenum.2label.tre";
open OUT3, ">cluster$filenum.1label.tre";

while (<IN>)
	{	$line = $_;
		chomp $line;
		$line =~ s/:(\d+)e-\d+//g;
		$line =~ s/:(\d+).\d+e-\d+//g;
		$line =~ s/:(\d+).\d+//g;
		print OUT "$line";
		
		$line =~ s/Ceratodon_R40/Ceratodon_R40 #1/g;
		$line =~ s/Ceratodon_GG1/Ceratodon_GG1 #2/g;
		print OUT2 "$line";
		
	}	

open IN2, "<$tree_file" or die "Tree not working (part2)\n";

while (<IN2>)
	{	$line2 = $_;
		chomp $line2;
		$line2 =~ s/:(\d+)e-\d+//g;
		$line2 =~ s/:(\d+).\d+e-\d+//g;
		$line2 =~ s/:(\d+).\d+//g;		
		$line2 =~ s/Ceratodon_R40,Ceratodon_GG1\)/Ceratodon_R40 #1,Ceratodon_GG1 #1\) #1/g;
		$line2 =~ s/Ceratodon_GG1,Ceratodon_R40\)/Ceratodon_GG1 #1,Ceratodon_R40 #1\) #1/g;
		print OUT3 "$line2";
		
	}	
}	

close IN;
close IN2;
close OUT;
close OUT2;
close OUT3;

