#!/usr/bin/perl -w

## Written by Sarah B. Carey

## this script takes multiple alignment files each containing only one-to-one U and V
## orthologs and converts them to axt format for use in KaKs Calculator

# usage = "perl <script_name> <file_extension_to_pull_from>"

$file_ext = $ARGV[0]; 
@file_array = glob "*$file_ext";

open OUT, ">ceratodon_sex.axt";

for $file (@file_array)
	{
	if ($file =~ m /([\s\S]+)(\.pep.fa.aln.unwrap.fa.pal2nal.fa.unwrap.fa.out.sex.fa)/) 
		{
		$file_name = $1;
		open IN, "<$file";
			
	while (<IN>)
		{
		$line = $_;
	 		
	 		if ($line =~ m/>([\s\S]+)/)
				{	
					$seq = <IN>;
					$second_head = <IN>;
					$second_seq =<IN>;
					print OUT "$file_name\n$seq$second_seq\n";
				}
			else
				{
				if ($line =~ m/(\S+)/)
					{
					print "";
					}		
				}
		}
		}
		}
close IN;
close OUT;

