#!/bin/bash
# Usage ./SCRIPT [instance file] (nb of new tasks) (min walk length) (max walk length)
# To change the sampling techniques take a look at
# $FD_GENERATOR/src/search/task_utils/sampling_technique.cc. All sampling
# techniques are registered as FD Plugin in this file. Search for
# "> _parse_technique_" to find all methods describing sampling techniques.

SOURCE_PDDL=${1:-"$(dirname "$0")/source.pddl"} # PDDL file from which new tasks shall be generated
NB_PROBLEMS=${2:-1}  # Number of tasks to generate
PROB_PREFIX=${5:-""} # Prefix of problem filename

# Definition of the technique to use for sampling.
SEED_LENGTH=$RANDOM$((RANDOM / 10))
SEED_WALK=$RANDOM$((RANDOM / 10))
MIN_WALK_LENGTH=50  # Minimum walk length
MAX_WALK_LENGTH=201  # Maximum walk length
# Sampling technique that does progression from the initial state
#SAMPLING_TECHNIQUE="iforward_none(${NB_PROBLEMS},distribution=uniform_int_dist(${MIN_WALK_LENGTH},${MAX_WALK_LENGTH},random_seed=${SEED_LENGTH}),random_seed=${SEED_WALK})"
# Sampling technique that does regression from the goal assignment
SAMPLING_TECHNIQUE="gbackward_none(${NB_PROBLEMS},distribution=uniform_int_dist(${MIN_WALK_LENGTH},${MAX_WALK_LENGTH},random_seed=${SEED_LENGTH}),random_seed=${SEED_WALK})"


# Sample new tasks and store them in the SAS format
"${FD_GENERATOR}"/fast-downward.py "$SOURCE_PDDL" \
  --translate-options --keep-unreachable-facts --keep-unimportant-variables \
  --search-options --search "generator(write_statistics=false,techniques=[${SAMPLING_TECHNIQUE}])" > /dev/null

# Translate them back to PDDL
for (( i=0; i<"${NB_PROBLEMS}"; i++ )); do
  "${FD_GENERATOR}"/change_pddl_init_via_sas.py "${SOURCE_PDDL}" "sas_plan${i}"  > "${PROB_PREFIX}_p${i}.pddl"
  rm "sas_plan${i}"
done
rm output.sas

