from default_args import get_training_args, DomainAndProblemConfiguration
from train import train_wrapper

_CONFIGURATION = DomainAndProblemConfiguration(
    base_directory="../benchmarks/zenotravel",
    domain_pddl="domain.pddl",
    problem_pddls=[
        "train/zenotravel-cities2-planes1-people2-1864.pddl",
        "train/zenotravel-cities2-planes1-people3-8798.pddl",
        "train/zenotravel-cities2-planes2-people2-7284.pddl",
        "train/zenotravel-cities2-planes2-people3-9145.pddl",
        "train/zenotravel-cities2-planes3-people2-1325.pddl",
        "train/zenotravel-cities2-planes3-people3-3417.pddl",
        "train/zenotravel-cities2-planes3-people4-7627.pddl",
        "train/zenotravel-cities2-planes4-people2-4892.pddl",
        "train/zenotravel-cities2-planes4-people3-1657.pddl",
        "train/zenotravel-cities2-planes4-people4-6874.pddl",
        "train/zenotravel-cities3-planes1-people2-8152.pddl",
        "train/zenotravel-cities3-planes1-people3-4791.pddl",
        "train/zenotravel-cities3-planes2-people2-9581.pddl",
        "train/zenotravel-cities3-planes2-people3-8752.pddl",
        "train/zenotravel-cities3-planes2-people4-6913.pddl",
        "train/zenotravel-cities3-planes2-people5-7306.pddl",
        "train/zenotravel-cities3-planes3-people2-8942.pddl",
        "train/zenotravel-cities3-planes3-people3-1826.pddl",
        "train/zenotravel-cities3-planes3-people4-2981.pddl",
        "train/zenotravel-cities3-planes3-people5-4582.pddl",
    ],
)

if __name__ == "__main__":
    train_wrapper(
        args=get_training_args(
            configurations=[_CONFIGURATION],
            # 10 minutes
            max_training_time=10 * 60,
        )
    )
