from default_args import get_training_args, DomainAndProblemConfiguration
from train import train_wrapper

_CONFIGURATION = DomainAndProblemConfiguration(
    base_directory="../benchmarks/sokoban",
    domain_pddl="domain.pddl",
    problem_pddls=[
    "sokoban-grid5-boxes2-walls3-0.pddl",
    "sokoban-grid5-boxes2-walls3-1.pddl",
    "sokoban-grid5-boxes2-walls3-6.pddl",
    "sokoban-grid5-boxes2-walls3-7.pddl",
    "sokoban-grid5-boxes2-walls3-8.pddl",
    "sokoban-grid5-boxes2-walls4-2.pddl",
    "sokoban-grid5-boxes2-walls4-3.pddl",
    "sokoban-grid5-boxes2-walls4-4.pddl",
    "sokoban-grid5-boxes2-walls4-5.pddl",
    "sokoban-grid5-boxes2-walls5-9.pddl",
    "sokoban-grid7-boxes2-walls3-2.pddl",
    "sokoban-grid7-boxes2-walls3-3.pddl",
    "sokoban-grid7-boxes2-walls3-4.pddl",
    "sokoban-grid7-boxes2-walls3-7.pddl",
    "sokoban-grid7-boxes2-walls4-5.pddl",
    "sokoban-grid7-boxes2-walls4-6.pddl",
    "sokoban-grid7-boxes2-walls4-8.pddl",
    "sokoban-grid7-boxes2-walls4-9.pddl",
    "sokoban-grid7-boxes2-walls5-0.pddl",
    "sokoban-grid7-boxes2-walls5-1.pddl",
    ],
)

if __name__ == "__main__":
    train_wrapper(
        args=get_training_args(
            configurations=[_CONFIGURATION],
            # 10 minutes
            max_training_time=10 * 60,
        )
    )
