from default_args import get_training_args, DomainAndProblemConfiguration
from train import train_wrapper

_CONFIGURATION = DomainAndProblemConfiguration(
    base_directory="../benchmarks/matching-blocksworld",
    domain_pddl="domain.pddl",
    problem_pddls=[
        "../matching-blocksworld/mbw-b3-t1-s142.pddl",
        "../matching-blocksworld/mbw-b3-t1-s287.pddl",
        "../matching-blocksworld/mbw-b3-t1-s378.pddl",
        "../matching-blocksworld/mbw-b3-t1-s462.pddl",
        "../matching-blocksworld/mbw-b3-t1-s547.pddl",
        "../matching-blocksworld/mbw-b3-t2-s604.pddl",
        "../matching-blocksworld/mbw-b3-t2-s759.pddl",
        "../matching-blocksworld/mbw-b3-t2-s861.pddl",
        "../matching-blocksworld/mbw-b3-t2-s975.pddl",
        "../matching-blocksworld/mbw-b3-t2-s1572.pddl",
        "../matching-blocksworld/mbw-b4-t1-s1.pddl",
        "../matching-blocksworld/mbw-b4-t1-s2.pddl",
        "../matching-blocksworld/mbw-b4-t1-s3.pddl",
        "../matching-blocksworld/mbw-b4-t1-s4.pddl",
        "../matching-blocksworld/mbw-b4-t1-s5.pddl",
        "../matching-blocksworld/mbw-b4-t2-s6.pddl",
        "../matching-blocksworld/mbw-b4-t2-s7.pddl",
        "../matching-blocksworld/mbw-b4-t2-s8.pddl",
        "../matching-blocksworld/mbw-b4-t2-s9.pddl",
        "../matching-blocksworld/mbw-b4-t2-s10.pddl",
        "../matching-blocksworld/mbw-b5-t1-s21.pddl",
        "../matching-blocksworld/mbw-b5-t1-s22.pddl",
        "../matching-blocksworld/mbw-b5-t1-s23.pddl",
        "../matching-blocksworld/mbw-b5-t1-s24.pddl",
        "../matching-blocksworld/mbw-b5-t1-s25.pddl",
        "../matching-blocksworld/mbw-b5-t2-s26.pddl",
        "../matching-blocksworld/mbw-b5-t2-s27.pddl",
        "../matching-blocksworld/mbw-b5-t2-s28.pddl",
        "../matching-blocksworld/mbw-b5-t2-s29.pddl",
        "../matching-blocksworld/mbw-b5-t2-s30.pddl",
    ],
)

if __name__ == "__main__":
    train_wrapper(
        args=get_training_args(
            configurations=[_CONFIGURATION],
            num_bins=4,
            max_training_time=10 * 60,
        )
    )
