from default_args import get_training_args, DomainAndProblemConfiguration
from train import train_wrapper

_CONFIGURATION = DomainAndProblemConfiguration(
    base_directory="../benchmarks/hanoi",
    domain_pddl="domain.pddl",
    problem_pddls=[
        "hanoi-n3.pddl",
        "hanoi-n4.pddl",
    ],
)

if __name__ == "__main__":
    train_wrapper(
        args=get_training_args(
            configurations=[_CONFIGURATION],
            num_bins=3,
            max_training_time=10 * 60
        )
    )
