#ifndef TASK_UTILS_ASSIGNMENT_COST_GENERATOR_H
#define TASK_UTILS_ASSIGNMENT_COST_GENERATOR_H

#include "sampling.h"
#include "successor_generator_internals.h"
#include "../per_task_information.h"

#include <memory>
#include <vector>

class GlobalState;
class OperatorID;
class PartialAssignment;
class TaskProxy;
class OperatorsProxy;

namespace assignment_cost_generator {
    using namespace successor_generator;
    using namespace sampling;

class AssignmentCostGenerator {
    std::unique_ptr<GeneratorBase> root;
public:
    explicit AssignmentCostGenerator(
            const TaskProxy &task_proxy,
            const PartialAssignmentRegistry &partial_assignment_registry,
            const utils::HashMap<size_t, int> &id2costs);
    explicit AssignmentCostGenerator(
            const TaskProxy &task_proxy,
            const std::vector<PartialAssignment> assignments,
            const int unit_cost);
    /*
      We cannot use the default destructor (implicitly or explicitly)
      here because GeneratorBase is a forward declaration and the
      incomplete type cannot be destroyed.
    */
    ~AssignmentCostGenerator() = default;

    int lookup_cost(const PartialAssignment &assignment) const;
};

}

#endif
