#include "assignment_cost_generator.h"

#include "assignment_cost_generator_factory.h"
#include "sampling.h"
#include "successor_generator_factory.h"
#include "task_properties.h"

#include "../global_state.h"
#include "../task_proxy.h"

#include "../utils/hash.h"

#include <set>

using namespace std;

namespace assignment_cost_generator {
AssignmentCostGenerator::AssignmentCostGenerator(
        const TaskProxy &task_proxy,
        const PartialAssignmentRegistry &partial_assignment_registry,
        const utils::HashMap<size_t, int> &id2costs)
: root(AssignmentCostGeneratorFactory(
        task_proxy,
        partial_assignment_registry, id2costs).create()) {}

AssignmentCostGenerator::AssignmentCostGenerator(
        const TaskProxy &task_proxy,
        const std::vector<PartialAssignment> assignments,
        const int unit_cost)
        : root(AssignmentUnitCostGeneratorFactory(
                task_proxy, assignments, unit_cost).create()){}

int AssignmentCostGenerator::lookup_cost(const PartialAssignment &assignment) const {
        return root->generate_min_applicable_op(assignment, true).get_index();
}
}
