#ifndef SEARCH_ENGINES_OVERLAP_SEARCH_H
#define SEARCH_ENGINES_OVERLAP_SEARCH_H

#include "../open_list.h"
#include "../search_engine.h"

#include "../task_utils/assignment_cost_generator.h"
#include "../task_utils/sampling_technique.h"
#include "../utils/countdown_timer.h"
#include "../utils/hash.h"

#include <functional>
#include <memory>
#include <ostream>
#include <sstream>
#include <tree.hh>
#include <vector>

namespace options {
class Options;
}

namespace overlap_search {
class OverlapSearch : public SearchEngine {
protected:
    std::vector<std::shared_ptr<sampling_technique::TechniqueGBackwardNone>> base_techniques;
    const std::vector<std::shared_ptr<sampling_technique::SamplingTechnique>> sampling_techniques;
    const double max_base_generation_time;
    const double max_technique_generation_time;
    utils::CountdownTimer timer;
    std::vector<PartialAssignment> bases;
    std::shared_ptr<assignment_cost_generator::AssignmentCostGenerator> base_generator;
private:
    std::vector<std::shared_ptr<sampling_technique::TechniqueGBackwardNone>>::const_iterator base_technique;
    std::vector<std::shared_ptr<sampling_technique::SamplingTechnique>>::const_iterator sampling_technique;

protected:
    int nb_generated = 0;
    int nb_overlap = 0;
    int index_technique = 0;
    std::ostringstream output;

    virtual void initialize() override;
    virtual SearchStatus step() override;

public:
    explicit OverlapSearch(const options::Options &opts);
    virtual ~OverlapSearch() = default;
    static void add_overlap_options(options::OptionParser &parser);
};
}
#endif
