#ifndef SEARCH_ENGINES_GENERATOR_SEARCH_H
#define SEARCH_ENGINES_GENERATOR_SEARCH_H

#include "../open_list.h"
#include "../search_engine.h"

#include "../task_utils/sampling_technique.h"
#include "../utils/hash.h"

#include <functional>
#include <memory>
#include <ostream>
#include <sstream>
#include <tree.hh>
#include <vector>

namespace options {
class Options;
}

namespace generator_search {
class GeneratorSearch : public SearchEngine {
protected:
    const std::vector<std::shared_ptr<sampling_technique::SamplingTechnique>> sampling_techniques;
private:
    std::vector<std::shared_ptr<sampling_technique::SamplingTechnique>>::const_iterator current_technique;
    int index_current_problem;
protected:
    const int count_total_problems;
    const bool write_sas;
    const bool write_statistics;
    const bool count_sample_frequency;
    const int count_fact_frequencies;
    const int cache_statistics;
    int count_cache_statistics;

    utils::HashMap<std::pair<std::vector<int>, std::vector<std::pair<int, int>>>, int> sample_frequency;
    std::vector<utils::HashMap<std::vector<FactPair>, int>> fact_frequencies;

private:
    void write_sas_to_file();
    void write_statistics_to_file();

    void update_sample_frequencies(std::shared_ptr<AbstractTask> new_task);
    void update_fact_frequencies(std::shared_ptr<AbstractTask> new_task);

protected:
    std::vector<std::shared_ptr<sampling_technique::SamplingTechnique>> prepare_sampling_techniques(
        std::vector<std::shared_ptr<sampling_technique::SamplingTechnique>> input) const;
    virtual void initialize() override;
    virtual SearchStatus step() override;

public:
    explicit GeneratorSearch(const options::Options &opts);
    virtual ~GeneratorSearch() = default;
    static void add_generator_options(options::OptionParser &parser);
};
}
#endif
