import json
import os
from json import JSONEncoder
from typing import Dict, List, Tuple, FrozenSet


class StateValuePair(object):
    """
    A pair which consists of a state and heuristic value.
    This can't be a NamedTuple otherwise the default json encoder complains.
    """

    def __init__(self, state: FrozenSet[str], value):
        self.state: FrozenSet[str] = state
        self.value: Number = value

    def __repr__(self):
        return f"StateValuePair(state={self.state}, value={self.value})"

    def to_json_dict(self) -> dict:
        # For saving training data
        json_dict = {
            "state": [prop for prop in self.state],
            "value": self.value,
        }
        return json_dict


class _TrainingDataEncoder(JSONEncoder):
    def default(self, o):
        if isinstance(o, StateValuePair):
            return o.to_json_dict()
        else:
            super(_TrainingDataEncoder, self).default(o)
