from abc import ABC, abstractmethod
import tempfile
import logging
import random
import os
import subprocess
import pathlib
import time

_log = logging.getLogger(__name__)


class Generator(ABC):
    @abstractmethod
    def initialize_parameter_space(self, fd_planning_time, total_time):
        raise NotImplementedError

    @abstractmethod
    def is_initialized(self):
        raise NotImplementedError

    @abstractmethod
    def sample_problem(self):
        raise NotImplementedError

    @abstractmethod
    def max_receivers(self):
        raise NotImplementedError

    @abstractmethod
    def max_senders(self):
        raise NotImplementedError


class RandomWalkGenerator:
    """ Uses the random walk generator of Patrick Ferber to generate data.
    """

    def __init__(self, generator_script, domain, lower_bound, upper_bound):
        self.script = generator_script
        self.domain = domain
        self._lb = lower_bound
        self._ub = upper_bound

    def initialize_parameter_space(self, fd_planning_time, total_time):
        # For now we do not initialize the parameter space
        raise NotImplementedError

    def is_initialized(self):
        return True

    def call_generator(self, instance, num_problems, prefix):
        call_string = (
            f"./{self.script} {instance} {num_problems} {self._lb} {self._ub} {prefix}"
        )
        exitcode = subprocess.call(call_string, shell=True)
        problems = [f"{prefix}_p{i}.pddl" for i in range(num_problems)]
        return problems
