# FD Generator

This is an adaption of the [Fast Downward planning system](http://www.fast-downward.org/)
which was adapted again to contain only the feature to generate new tasks given
a PDDL file (actually most of the code is still there, but disabled in CMake).
For questions, help or request converning this framework contact 
Patrick Ferber (patrick.ferber@unibas.ch)

Fast Downward is a domain-independent planning system.
For documentation and contact information see http://www.fast-downward.org/.

## Setup
The same setup as for a normal Fast Downward repository should apply (python,
cmake, gcc).
1. install the requirements of Fast Downward
2. copy this directory somewhere
3. build Fast Downward (any version you like, the default is currently release64dynamic)
4. add a variable `FD_GENERATOR` to your environment
5. use `./run_my_generator.sh` to generate new tasks from a base task (you may
   copy this script into any directory of your choice, it uses internally the
   `FD_GENERATOR` variable`).
   - There are comments within the `run_my_generator.sh` script to explain what
     is happening. The command line arguments are explained on the top.
   - If you change the build, then you have to adapt the Fast Downward call to
     use your build.
     
## Generating state-value pairs of optimal plans
After following the steps in the setup guide above you can use the script
`generator_scripts/strips_hgn_problem_gen_multi.py` to generate optimal plans.
First, open the script and change in line 165-170 the total time, minimum time
to consider the problem not trivial, and the maximum time for a problem.
You can also set the number of cores that are used with num_workers.
Then, call the script on a folder of problem instances (including domain file)
of the instances for which you want to generate data for, e.g.
`python3 strips_hgn_problem_gen_multi.py ../../downward-benchmarks/blocks/`.
The resulting data will be stored in `data_file_worker-i.json`, where i goes
from 1 to max number of cpu's you specified.


     
## License
The following directories are not part of Fast Downward as covered by this
license:

* ./src/search/ext

For the rest, the following license applies:

```
Fast Downward is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation, either version 3 of the License, or (at your option) any later
version.

Fast Downward is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this program. If not, see <http://www.gnu.org/licenses/>.
```

