import os


def rename_algorithm(algo):
    if algo.find("INCLUDE_BASE_AVI") > -1:
        return "hAVI"
    elif algo.find("INCLUDE_BASE_SEARCHReg") > -1:
        return "hBoot"
    elif algo.find("INCLUDE_BASE_SEARCHXReg") > -1:
        return "hBExp"
    elif algo.find("lama") > -1 and algo.find("infai1") > -1:
        return "LAMA"
    elif algo.find("ocls_") > -1:
        return "hSL"
    elif algo.find("hgn") > -1:
        return "hHGN"
    elif algo.find("ff-infai1") > -1:
        return "hFF"
    else:
        return algo


def rename_task(task):
    if task.startswith("prob-B-"):
        return task.replace("-B-", "BLOCKS-")
    return task


FILE_PROPERTIES_WITHOUT = "/home/ferber/repositories/DeePDown/misc/reinforcement_learning/experiments/data/2020-12-01-Merge-RL-WithoutValidation.py-eval/properties"
MODERATE_TASKS = (
    [os.path.join('blocks', rename_task(x)) for x in ['probBLOCKS-14-0', 'probBLOCKS-15-0', 'probBLOCKS-15-1', 'probBLOCKS-16-1', 'probBLOCKS-17-0']] +
    [os.path.join('depot', x) for x in ['p05', 'p08', 'p09', 'p11', 'p15', 'p16']] +
    [os.path.join('grid', x) for x in ['prob03', 'prob04']] +
    [os.path.join('npuzzle', x) for x in ['prob_n6_1', 'prob_n6_2', 'prob_n6_3', 'prob_n6_4', 'prob_n7_1', 'prob_n7_2', 'prob_n7_3', 'prob_n7_4']] +
    [os.path.join('pipesworld-notankage', x) for x in ['p19-net2-b18-g6', 'p21-net3-b12-g2', 'p24-net3-b14-g5', 'p27-net3-b18-g6', 'p28-net3-b18-g7', 'p30-net3-b20-g8', 'p31-net4-b14-g3', 'p32-net4-b14-g5', 'p34-net4-b16-g6', 'p41-net5-b22-g2']] +
    [os.path.join('rovers', x) for x in ['p11', 'p18', 'p20', 'p21', 'p22', 'p23', 'p26', 'p28']] +
    [os.path.join('scanalyzer-opt11-strips', x) for x in ['p07', 'p10', 'p13', 'p15', 'p16', 'p20']] +
    [os.path.join('storage', x) for x in ['p18', 'p20', 'p21', 'p23']] +
    [os.path.join('transport-opt14-strips', x) for x in ['p10', 'p11', 'p12', 'p16', 'p17', 'p18', 'p19', 'p20']] +
    [os.path.join('visitall-opt14-strips', x) for x in ['p-1-12', 'p-1-13', 'p-1-14', 'p-1-15', 'p-1-16', 'p-1-17']]
)
MODERATE_TASKS = ['%s.pddl' % x for x in MODERATE_TASKS]

# prob04_1
HARD_TASKS = (
    [os.path.join('blocks', rename_task(x)) for x in ['prob-B-18-4', 'prob-B-20-1', 'prob-B-25-2', 'prob-B-30-1', 'prob-B-35-2']] +
    [os.path.join('depot', x) for x in ['p06', 'p12', 'p14', 'p18', 'p19', 'p20', 'p22']] +
    [os.path.join('grid', x) for x in ['prob04_2', 'prob04_3', 'prob04_4', 'prob05', 'prob05_1', 'prob05_2', 'prob05_3', 'prob05_4']] +
    [os.path.join('npuzzle', x) for x in ['prob_n8_1', 'prob_n8_2', 'prob_n8_3', 'prob_n8_4', 'prob_n9_1', 'prob_n9_2', 'prob_n9_3', 'prob_n9_4']] +
    [os.path.join('pipesworld-notankage', x) for x in ['p22-net3-b12-g4', 'p25-net3-b16-g5', 'p26-net3-b16-g7', 'p29-net3-b20-g6', 'p33-net4-b16-g5', 'p35-net4-b18-g4', 'p36-net4-b18-g6', 'p37-net4-b20-g5', 'p38-net4-b20-g7', 'p39-net4-b22-g7', 'p40-net4-b22-g8', 'p42-net5-b22-g4', 'p43-net5-b24-g3', 'p44-net5-b24-g5', 'p45-net5-b26-g4', 'p46-net5-b26-g6', 'p47-net5-b28-g5', 'p48-net5-b28-g7', 'p49-net5-b30-g6', 'p50-net5-b30-g8']] +
    [os.path.join('rovers', x) for x in ['p19', 'p24', 'p27', 'p29', 'p30', 'p31', 'p32', 'p33', 'p34', 'p35', 'p36', 'p37', 'p38', 'p39', 'p40']] +
    [os.path.join('scanalyzer-opt11-strips', x) for x in ['p17', 'p18', 'p19']] +
    [os.path.join('storage', x) for x in ['p19', 'p24', 'p25', 'p26', 'p27', 'p28', 'p29', 'p30']] +
    [os.path.join('transport-opt14-strips', x) for x in ['p31', 'p32', 'p33', 'p34', 'p35']] +
    [os.path.join('visitall-opt14-strips', x) for x in ['p-1-18']]
)
HARD_TASKS = ['%s.pddl' % x for x in HARD_TASKS]

ALL_TASKS = HARD_TASKS + MODERATE_TASKS

TASKS_PER_STATE_SPACE = 50
TASK_SETS = {
    "moderate": MODERATE_TASKS,
    "hard": HARD_TASKS,
    "all": ALL_TASKS,
}



def rename_technique(algo):
    a = algo['algorithm']
    approx_value_iteration = a.find("BASE_AVI") > -1
    search_samples = a.find("BASE_SEARCHReg") > -1
    lama = False
    # if a.find("GBFS10X") > -1:
    #     return None
    # lama = a.find("lama") > -1
    ecai = a == "ocls_ns_ubal_h3_sigmoid_inter_gen_sat_drp0_Kall_pruneOff_X_fold_model.pb"
    assert sum([approx_value_iteration, search_samples, lama, ecai]) == 1, a
    if approx_value_iteration:
        algo["algorithm"] = "1avi"
    elif search_samples:
        algo["algorithm"] = "2search"
    # elif lama:
    #     algo["algorithm"] = "3lama"
    elif ecai:
        algo["algorithm"] = "0ecai"
    else:
        assert False, a
    return algo


