import os
import shutil
import sys

if sys.version_info < (3,):
    FileNotFoundError = OSError
    FileExistsError = OSError


DIR_REPO = os.path.dirname(os.path.dirname(__file__))
DIR_SLURM_SCRIPTS = os.path.join(DIR_REPO, "misc", "slurm")
SCRIPT_SLURM_CONVERT = os.path.join(DIR_SLURM_SCRIPTS, "slurm-convert.sh")
SCRIPT_SLURM_SUMMARIZE_TRAINING = os.path.join(DIR_SLURM_SCRIPTS,
                                               "summarize_training_output.sh")


def check_paths():
    is_cached_revision = DIR_REPO.find("/code-") > -1

    def removed_by_lab(x):
        return (is_cached_revision and
                (x.find("/misc/") > -1 or x.find("/experiments/") > -1))

    for k, v in globals().items():
        if any(k.startswith(x) for x in ["SCRIPT_", "FILE_"]):
            assert os.path.isfile(v) or removed_by_lab(v), \
                "%s is not a file" % v
        if k.startswith("DIR_"):
            assert os.path.isdir(v) or removed_by_lab(v), "%s is not a dir" % v


check_paths()


def remove(path, missing_ok=False):
    """
    TODO: make more general
    :param path:
    :param missing_ok:
    :return:
    """
    try:
        os.remove(path)
    except FileNotFoundError as e:
        if sys.version_info < (3,) and e.errno == 39:
            # Directory not empty (e.g. due to another process writing into the
            # directory while we try to delete it
            sys.stderr("unable to delte dir", path)
            sys.stderr.flush()
        elif not missing_ok or (sys.version_info < (3,) and e.errno != 2):
            raise


def remove_dir(path, missing_ok=False):
    """
    TODO: make more general
    :param path:
    :param missing_ok:
    :return:
    """
    try:
        shutil.rmtree(path)
    except FileNotFoundError as e:
        if not missing_ok or (sys.version_info < (3,) and
                              e.errno != 2 and e.errno != 39):
            raise


def make_dirs(path, exist_ok=False):
    try:
        os.makedirs(path)
    except FileExistsError:
        if not exist_ok:
            raise


def move(src, trg, create_parents=False):
    if create_parents and os.path.dirname(trg) != "":
        make_dirs(os.path.dirname(trg), exist_ok=True)
    shutil.move(src, trg)


if __name__ == "__main__":
    print("Thou shall not call me directly.")
    assert False
