class SampleTypes(object):
    """Till now used only by fast-training.py"""
    name2type = {}

    def __init__(self, name, subtypes, description):
        self.name = name
        self.subtypes = subtypes
        self.description = description
        SampleTypes.name2type[self.name] = self

    def __str__(self):
        return self.name

    @staticmethod
    def get(name):
        return SampleTypes.name2type[name]

    @staticmethod
    def types():
        return SampleTypes.name2type.values()


SampleTypes.all = SampleTypes("all", None, "load all samples")
SampleTypes.init = SampleTypes("init", ["init"], "load only initial states")
SampleTypes.inter = SampleTypes("inter", ["inter"],
                                "load only intermediate states (not initial "
                                "states)")
SampleTypes.plan = SampleTypes("plan", ["init", "inter"],
                               "loads all samples on the solution path of the "
                               "sampled problems")
