import keras
from keras import backend as K


def mean_absolute_percentage_error_plus_one(y_true, y_pred):
    loss = K.abs(y_pred - y_true) / (y_true + 1)
    return K.mean(loss)


def mean_squared_percentage_error_plus_one(y_true, y_pred):
    loss = K.square(K.abs(y_pred - y_true) / (y_true + 1))
    return K.mean(loss)


def mean_absolute_max_error_plus_one(y_true, y_pred):
    loss = K.abs(y_true - y_pred) / (K.maximum(y_true, y_pred) + 1)
    return K.mean(loss)


def mean_absolute_min_error_plus_one(y_true, y_pred):
    loss = K.abs(y_true - y_pred) / (K.minimum(y_true, y_pred) + 1)
    return K.mean(loss)


def mean_squared_min_error_plus_one(y_true, y_pred):
    loss = K.square(K.abs(y_true - y_pred) / (K.minimum(y_true, y_pred) + 1))
    return K.mean(loss)

LOSSES = {
    "mean_absolute_percentage_error_plus_one":
        mean_absolute_percentage_error_plus_one,
    "mapepo": mean_absolute_percentage_error_plus_one,
    "mean_squared_percentage_error_plus_one":
        mean_squared_percentage_error_plus_one,
    "mspepo": mean_squared_percentage_error_plus_one,
    "mean_absolute_max_error_plus_one": mean_absolute_max_error_plus_one,
    "mamepo": mean_absolute_max_error_plus_one,
    "mean_absolute_min_error_plus_one": mean_absolute_min_error_plus_one,
    "mamipo": mean_absolute_min_error_plus_one,
    "mean_squared_min_error_plus_one": mean_squared_min_error_plus_one,
    "msmipo": mean_squared_min_error_plus_one,
}


def get(loss):
    if loss in LOSSES:
        return LOSSES[loss]
    else:
        return keras.losses.get(loss)
