from abc import ABCMeta

from .base_learner import Learner

from .. import parser
from .. import parser_tools as parset

from ..parser_tools import main_register, ArgumentException

import os


class Network(Learner):
    """
    Base class for all neural networks.
    Do not forget to register your network subclass in this packages 'register'
    dictionary via 'append_register' of the main package.
    """

    __metaclass__ = ABCMeta
    arguments = parset.ClassArguments(
        "Network", Learner.arguments
    )

    def get_store_path(self, path=None):
        path = self.path_store if path is None else path
        path = os.path.join("." if self.path_out is None else self.path_out,
                            "network") if path is None else path
        return path

    @staticmethod
    def parse(tree, item_cache):
        obj = parser.try_lookup_obj(tree, item_cache, Network, None)
        if obj is not None:
            return obj
        else:
            raise ArgumentException("The definition of the base network can "
                                    "only be used for look up of any previously"
                                    " defined schema via 'Sampler(id=ID)'")


main_register.append_register(Network, "network")
nregister = main_register.get_register(Network)
