from src.training import AbstractBaseClass

import abc

KEYWORD_FIELD = "field"
KEYWORD_TYPE = "type"
KEYWORD_FORWARD = "forward"

FIELD_PARSERS = {}

'''
cached_parse_kwargs = {}
cached_unparse_kwargs = {}

def nested_copy(obj):
    if isinstance(obj, dict):
        return {nested_copy(key): nested_copy(value) for key, value in obj.items()}
    if hasattr(obj, '__iter__'):
        return type(obj)(nested_copy(item) for item in obj)
    return obj

def use_cached_kwargs(cache, parser, description, list_kwargs):
    str_value = (str(description), str(list_kwargs))
    if str_value not in cache:
        list_kwargs = nested_copy(list_kwargs)
        cache[str_value] = parser.prepare_kwargs(description, list_kwargs)
    return cached_parse_kwargs[str_value]
'''
def get_argument_for_parser(key, description, user_kwargs, module_kwargs,
                            converter_user=None,
                            converter_module=None,
                            converter_description=None):
    """
    Extracts a parameter for a parser. The priority is:
    1. Look in user provided parameters,
    2. Look in module provided parameters,
    3. Look in parameters given by the sample entries description
    :param key: Name of the parameter to extract
    :param description: parsed json of the field description in the sample
                        (all entries are strings)
    :param user_kwargs: map of additional arguments given by the user (all
                        entries are strings)
    :param module_kwargs: map of additional parameters provided by the code
                          during the method call (keys and values can be of
                          arbitrary types)
    :param converter_user: if the value is taken from the user given parameters,
                           this callable converts the string to the object it
                           shall be
    :param converter_module: if the value is taken from the module provided
                             parameters, then this converter is used
    :param converter_description: if the values is taken from the sample entries
                                  description, this converter is used.
    :return:
    """
    if user_kwargs is not None and key in user_kwargs:
        return user_kwargs[key] if converter_user is None else converter_user(user_kwargs[key])
    elif key in module_kwargs and module_kwargs[key] is not None:
        return module_kwargs[key] if converter_module is None else converter_module(module_kwargs[key])
    elif key in description:
        return description[key] if converter_description is None else converter_description(description[key])
    return None

class FieldParser(AbstractBaseClass):
    """
    PREPARE KWARGS ONLY ONCE (OR COPY IT EVERY TIME), BECAUSE THIS MODIFIES
    LIST_KWARGS.
    """
    def parse(self, data, description, list_kwargs=None, **kwargs):
        #list_kwargs = use_cached_kwargs(cached_parse_kwargs, self,
        #                                description, list_kwargs)

        return self._parse(data, description, list_kwargs, **kwargs)

    @abc.abstractmethod
    def _parse(self, data, description, list_kwargs=None, **kwargs):
        """

        :param data: Data to parse
        :param description: json file providing meta information about the data
        :param list_kwargs: [{kwargs}, {kwargs},...] list providing additional
                            parameters (which the user can define via commandline)
                            The i-th FieldParser uses the i-th {kwargs} dict.
                            Thus, only if the forward parsing is used, multiple
                            dicts in the list are useful.
        :param kwargs: Additional kwargs which are given to ALL FieldParsers in
                       the chain. This is specified by the program not the user.
        :return: description (if not modified possible the same as the input,
        if modified, then a new item) and Parsed data entry
        """
        pass

    def unparse(self, data, description, list_kwargs=None, **kwargs):
        #list_kwargs = use_cached_kwargs(cached_unparse_kwargs, self,
        #                                description, list_kwargs)

        return self._unparse(data, description, list_kwargs, **kwargs)

    @abc.abstractmethod
    def _unparse(self, data, description, list_kwargs=None):
        """

        :param data: Data to parse
        :param description: json file providing meta information about the data
        :param list_kwargs: [{kwargs}, {kwargs},...] list providing additional
                            parameters (which the user can define via commandline)
                            The i-th FieldParser uses the i-th {kwargs} dict.
                            Thus, only if the forward parsing is used, multiple
                            dicts in the list are useful.
        :param kwargs: Additional kwargs which are given to ALL FieldParsers in
                       the chain. This is specified by the program not the user.
        :return: description (as this might now be changed) and string of data
        """
        pass
    '''
    def prepare_kwargs(self, description, list_kwargs=None):
        if list_kwargs is None or len(list_kwargs) == 0:
            return
        self._recursive_prepare_kwargs(description, list_kwargs, 0)


    def _recursive_prepare_kwargs(self, description, list_kwargs, index):
        if len(list_kwargs) <= index:
            return
        list_kwargs[index] = self._prepare_kwargs(description, list_kwargs[index])

        if len(list_kwargs) > index + 1 and KEYWORD_FORWARD not in description:
            raise ValueError("More Keyword list entries defined than forward "
                             "parsings exists.")

        if KEYWORD_FORWARD in description:
            next_description = description[KEYWORD_FORWARD]
            if KEYWORD_TYPE not in next_description:
                raise ValueError("Json meta of sample entry which has a forward"
                                 " field is missing a type in its forward "
                                 "block.")
            next_type = next_description[KEYWORD_TYPE]
            if next_type not in FIELD_PARSERS:
                raise KeyError("Type specified in Json meta does not exist.")
            next_parser = FIELD_PARSERS[next_type]
            next_parser._recursive_prepare_kwargs(next_description, list_kwargs, index + 1)



    @abc.abstractmethod
    def _prepare_kwargs(self, description, kwargs):
        pass
    '''


class StringFieldParser(FieldParser):
    def _parse(self, data, description, list_kwargs, **kwargs):
        return description, str(data)

    def _unparse(self, data, description, list_kwargs, **kwargs):
        return description, str(data)

    #def _prepare_kwargs(self, description, kwargs):
    #    return kwargs

FIELD_PARSERS["str"] = StringFieldParser()
FIELD_PARSERS["string"] = FIELD_PARSERS["str"]
FIELD_PARSERS[None] = FIELD_PARSERS["str"]

class IntFieldParser(FieldParser):
    def _parse(self, data, description, list_kwargs, **kwargs):
        return description, int(data)

    def _unparse(self, data, description, list_kwargs, **kwargs):
        return description, str(data)

    #def _prepare_kwargs(self, description, kwargs):
    #    return kwargs

FIELD_PARSERS["int"] = IntFieldParser()
FIELD_PARSERS["integer"] = FIELD_PARSERS["int"]
FIELD_PARSERS["heuristic"] = FIELD_PARSERS["int"]