#include "overlap_search.h"
#include "sampling_engine.h"
#include "sampling_q.h"
#include "sampling_search.h"
#include "search_common.h"

#include "../option_parser.h"
#include "../plugin.h"

using namespace std;

namespace plugin_sampling {
static shared_ptr<SearchEngine> _parse_sampling_search(OptionParser &parser) {
    parser.document_synopsis("Sampling Search Manager", "");


    sampling_engine::SamplingSearch::add_sampling_search_options(parser);
    sampling_engine::SamplingEngine::add_sampling_options(
            parser, "fields", "pddl", ";", "\t");
    SearchEngine::add_options_to_parser(parser);
    
    

    Options opts = parser.parse();

    shared_ptr<sampling_engine::SamplingSearch> engine;
    if (!parser.dry_run()) {
        engine = make_shared<sampling_engine::SamplingSearch>(opts);
    }

    return engine;
}

static Plugin<SearchEngine> _plugin_search1("sampling", _parse_sampling_search);
static Plugin<SearchEngine> _plugin_search2("sampling_search", _parse_sampling_search);


static shared_ptr<SearchEngine> _parse_sampling_q(OptionParser &parser) {
    parser.document_synopsis("Sampling Search Manager", "");


    sampling_engine::SamplingQ::add_sampling_q_options(parser);
    sampling_engine::SamplingEngine::add_sampling_options(
            parser, "csv", "fdr", ";", ";");
    SearchEngine::add_options_to_parser(parser);
    
    

    Options opts = parser.parse();

    shared_ptr<sampling_engine::SamplingQ> engine;
    if (!parser.dry_run()) {
        engine = make_shared<sampling_engine::SamplingQ>(opts);
    }

    return engine;
}

static Plugin<SearchEngine> _plugin_q("sampling_q", _parse_sampling_q);


static shared_ptr<SearchEngine> _parse_sampling_overlap(OptionParser &parser) {
    parser.document_synopsis("Sampling Overlap Manager", "");


    overlap_search::OverlapSearch::add_overlap_options(parser);
    SearchEngine::add_options_to_parser(parser);

    Options opts = parser.parse();
    shared_ptr<overlap_search::OverlapSearch> engine;
    if (!parser.dry_run()) {
        engine = make_shared<overlap_search::OverlapSearch>(opts);
    }
    return engine;
}

static Plugin<SearchEngine> _plugin_overlap("overlap_search", _parse_sampling_overlap);
}

