#include "generator_search.h"
#include "search_common.h"

#include "../option_parser.h"
#include "../plugin.h"

using namespace std;

namespace plugin_generator {
static shared_ptr<SearchEngine> _parse(OptionParser &parser) {
    parser.document_synopsis("Generator Search Manager", "");


    generator_search::GeneratorSearch::add_generator_options(parser);
    SearchEngine::add_options_to_parser(parser);


    Options opts = parser.parse();

    shared_ptr<generator_search::GeneratorSearch> engine;
    if (!parser.dry_run()) {
        engine = make_shared<generator_search::GeneratorSearch>(opts);
    }

    return engine;
}

static Plugin<SearchEngine> _plugin("generator", _parse);
}
