#ifndef HEURISTICS_NETWORK_HEURISTIC_H
#define HEURISTICS_NETWORK_HEURISTIC_H

#include "../heuristic.h"

#include "../neural_networks/abstract_network.h"

#include <memory>

namespace network_heuristic {
/*Heuristic given state to a network and using its estimate as heuristic value.
 If the network also provides preferred operators, then they are also copied
 in this heuristic.*/
class NetworkHeuristic : public Heuristic {
protected:
    std::shared_ptr<neural_networks::AbstractNetwork> network;
    const bool blind;
    const int confidence_verbosity;
    const int min_operator_cost;
    
    virtual int compute_heuristic(const GlobalState &global_state) override;
    virtual int compute_heuristic(const State &state);
    std::pair<int, double> compute_heuristic_and_confidence(const GlobalState &state) override;


public:
    explicit NetworkHeuristic(const options::Options &options);
    ~NetworkHeuristic();
    
    // TODO: Networks accept batch data and send data as batch
    virtual std::vector<EvaluationResult> compute_results(
        std::vector<EvaluationContext> &eval_contexts) override;
};
}

#endif
