#!/bin/bash

BASE_DIR=$(dirname $0)
PATH_DATA="$BASE_DIR/experiments/data"
PATH_COMPARE_EXPERIMENTS="$BASE_DIR/compare_experiments.py"
PATH_COVERAGE_COMPARISON="$BASE_DIR/make_coverage_csv.py"

#$PATH_COMPARE_EXPERIMENTS $PATH_DATA 

BASELINE_IPC_DOMAINS=".*baseline_eager_greedy_ff(4|5).*"
MAIN_CONFIGURATIONS_IPC_DOMAINS="2019-05-(02|26)-cls_ns_ubal_h5_sigmoid_inter_gen_sat_drp0_Kall_pruneOff(_v2|_v3)?-eval"
REGEX_IPC_DOMAINS=".*(barman_p\d+-\d+|depot_p\d+|grid_prob\d+|npuzzle_n\d+|pipes_nt_p\d+|probBLOCKS-\d+-\d+|rovers_p\d+|scanalyzer_p\d+|storage_p\d+|transport_p\d+|visitall_p-\d+-\d+).*"
REGEX_IPC_DOMAINS_SHORT=".*(grid_prob04|rovers_p26|probBLOCKS-16-1|probBLOCKS-17-0|grid_prob03|pipes_nt_p31|transport_p10|probBLOCKS-14-0|storage_p18|pipes_nt_p41|rovers_p18|probBLOCKS-12-0|npuzzle_n6|transport_p20|transport_p05|depot_p05).*"
REGEX_ALGORITHM="EG-FF|cls_ns_.*"

# Baseline uniquely solved problems vs FF
#$PATH_COVERAGE_COMPARISON +coverage identity --regex-data "($BASELINE_IPC_DOMAINS|$MAIN_CONFIGURATIONS_IPC_DOMAINS)" --output "coverage_cls_ns_ubal_h5_sigmoid_inter_gen_sat_drp0_Kall_pruneOff.csv" --diff-output "unique_coverage_cls_ns_ubal_h5_sigmoid_inter_gen_sat_drp0_Kall_pruneOff.csv" --regex-domain $REGEX_IPC_DOMAINS --diff-size inf --regex-algorithm "EG-FF|cls_ns.*"

#Baseline TimeXCoverage for different hidden layer sizes
#$PATH_COVERAGE_COMPARISON +time --regex-data "(.*baseline_eager_greedy_ff4.*|2019-05-02-cls_ns_ubal_h\d+_sigmoid_inter_gen_sat_drp0_Kall_pruneOff(_v2)?-eval|2019-05-20-cls_ns_ubal_h(0|1|3)_sigmoid_inter_gen_sat_drp0_KAll_pruneOff-eval|2019-05-15-cls_ns_ubal_h(7|10)_sigmoid_inter_gen_sat_drp0_KAll_pruneOff-eval)" --output "coverageXtime_cls_ns_ubal_hXX_sigmoid_inter_gen_sat_drp0_Kall_pruneOff.pdf" --regex-domain $REGEX_IPC_DOMAINS


$PATH_COVERAGE_COMPARISON +time --regex-data "($BASELINE_IPC_DOMAINS|$MAIN_CONFIGURATIONS_IPC_DOMAINS)" --output "short_coverageXtime_cls_ns_ubal_h5_sigmoid_inter_gen_sat_drp0_Kall_pruneOff.pdf" --regex-domain $REGEX_IPC_DOMAINS_SHORT --regex-algorithm $REGEX_ALGORITHM

#$PATH_COVERAGE_COMPARISON +time --regex-data "(.*baseline_eager_greedy_ff4.*|2019-05-02-cls_ns_ubal_h\d+_sigmoid_inter_gen_sat_drp0_Kall_pruneOff(_v2)?-eval|2019-05-20-cls_ns_ubal_h3_sigmoid_inter_gen_sat_drp0_KAll_pruneOff-eval)" --output "short_coverageXtime_cls_ns_ubal_hXX_sigmoid_inter_gen_sat_drp0_Kall_pruneOff.pdf" --regex-domain $REGEX_IPC_DOMAINS_SHORT

#$PATH_COVERAGE_COMPARISON +time --regex-data "(.*baseline_eager_greedy_ff4.*|2019-05-02-cls_ns_ubal_h5_sigmoid_inter_gen_sat_drp0_Kall_pruneOff(_v2)?-eval)" --output "coverageXtime_cls_ns_ubal_h5_sigmoid_inter_gen_sat_drp0_Kall_pruneOff.pdf" --regex-domain $REGEX_IPC_DOMAINS




