#!/usr/bin/env python
from __future__ import print_function

import argparse
import os
import re
import sys


parser = argparse.ArgumentParser()
parser.add_argument("experiment", type=str, nargs="+",
                    help="Experiment files to modify")
parser.add_argument("-f", "--filter", type=str, required=True,
                    help="Regex to select which domains to run")
parser.add_argument("-s", "--suffix", type=str, required=True,
                    help="Suffix to append to the input experiment file names"
                         "(prior to the file type abbreviatio)")

PATTERN_BASE_EXPERIMENT = re.compile("base_experiment.get_base_experiment\((True|False)")

def parse_args(argv):
    options = parser.parse_args(argv)
    for file in options.experiment:
        assert os.path.isfile(file)
    _ = re.compile(options.filter)
    return options


def get_new_path(path_exp, suffix):
    path = os.path.splitext(path_exp)
    return path[0] + suffix + path[1]


def run(argv):
    options = parse_args(argv)
    insert = ", filter_benchmarks=\"%s\"" % options.filter
    linsert = len(insert)
    for path_in in options.experiment:
        path_out = get_new_path(path_in, options.suffix)
        with open(path_in, "r") as f:
            content = f.read()
            shift = 0
            for match in PATTERN_BASE_EXPERIMENT.finditer(content):

                content = (content[:match.end() + shift]
                           + insert
                           + content[match.end() + shift:])
                shift += linsert
        with open(path_out, "w") as f:
            f.write(content)

if __name__ == "__main__":
    run(sys.argv[1:])