#!/usr/bin/env python
from __future__ import print_function

import os
import re
import subprocess
import sys

PATTERN_JOB_ID = re.compile(r"slurm_.*_(\d+).out")
PATTERN_JOB_STATUS = re.compile(r"^(\d+)\s*(\S+)\s*$")

def check_dir(path_dir):
    jobs = []
    jobs_running = []
    for item in sorted(os.listdir(path_dir)):
        m = PATTERN_JOB_ID.match(item)
        if m is not None:
            jobs.append(m.groups()[0])

    command = ["sacct", "-j", ",".join(jobs), "--format", "JobIDRaw", "--format", "State"]
    slurm_output = subprocess.check_output(command)
    print("Running:")
    for line in slurm_output.split("\n"):
        m = PATTERN_JOB_STATUS.match(line)
        if m is not None and m.groups()[1] == "RUNNING":
            jobs_running.append(m.groups()[0])
            print(m.groups()[0])

    print("%s: %i/%i (Running/Total)" % (path_dir, len(jobs_running), len(jobs)))



if __name__ == "__main__":
    argv = sys.argv[1:]
    all_dir_exist = True
    for path_dir in argv:
        if not os.path.exists(path_dir):
            print("Given directory does not exist: %s" % path_dir)
            all_dir_exist = False
    if not all_dir_exist:
        exit(1)

    for path_dir in argv:
        check_dir(path_dir)