#!/usr/bin/env python

import os

from srce import rl_experiment
from srce import rl_experiment_factory


NN_EXPERIMENT = {EXPERIMENT_DIRECTORY}
BENCHMARK_REPO = "{BENCHMARK_DIRECTORY}"
CONFIGURATION_NAME = "{CONFIGURATION_NAME}"
OVERALL_TIME_LIMIT = "{OVERALL_TIME_LIMIT}"
PARTITION = "{PARTITION}"
MUTEX_OPTIONS = {MUTEX_OPTIONS} # options list, like for preprocessor
NETWORK_PREDEFINITIONS = {NETWORK_PREDEFINITIONS}
NEXT_EXPERIMENT = {NEXT_EXPERIMENT}

SORT_BY_COVERAGE = ["PATH TO THE ROBUSTNESS EXPERIMENTS"]
MAX_NB_MODELS = 1
SKIP_FIRST_MODEL = True

SUITES = [(os.path.join(BENCHMARK_REPO, d), x)
          for d in os.listdir(BENCHMARK_REPO)
          if os.path.isdir(os.path.join(BENCHMARK_REPO, d))
          for x in os.listdir(os.path.join(BENCHMARK_REPO, d))
          if os.path.isdir(os.path.join(BENCHMARK_REPO, d, x))]

factory = rl_experiment_factory.RobustnessExperimentFactory()
exp = factory.create_robustness_experiment(
    CONFIGURATION_NAME,
    NN_EXPERIMENT,
    BENCHMARK_REPO,
    SUITES,
    NETWORK_PREDEFINITIONS,
    rl_experiment_factory.Search.EagerGreedy.value,
    overall_time_limit=OVERALL_TIME_LIMIT,
    mutex_options=MUTEX_OPTIONS,
    partition=PARTITION,
    next_experiment=NEXT_EXPERIMENT,
    max_nb_models=MAX_NB_MODELS,
    skip_first_model=SKIP_FIRST_MODEL,
    sort_by_coverage_ratio=SORT_BY_COVERAGE,
)

exp.run_steps()
