#!/usr/bin/env python

import os

import rl_experiment
import rl_experiment_factory


# contains domain/task/model1..X
NN_MODELS = "/home/ferber/repositories/DeePDown/data/FixedWorlds/opt"
# contains domain/task ipc/task files
BENCHMARK_REPO = "/home/ferber/repositories/benchmarks_ecai"
MODEL_TEMPLATE = "ocls_ns_ubal_h3_sigmoid_inter_gen_sat_drp0_Kall_pruneOff_{}_fold_model.pb"
MODEL_TEMPLATE_VALUES = [i for i in range(10)]
OVERALL_TIME_LIMIT = "600m"
UNARY_THRESHOLD = 0.01
PARTITION = "infai_2"
#MUTEX_OPTIONS = {MUTEX_OPTIONS}  # options list, like for preprocessor

SUITES = [(os.path.join(BENCHMARK_REPO, d), x)
          for d in os.listdir(BENCHMARK_REPO)
          if os.path.isdir(os.path.join(BENCHMARK_REPO, d))
          for x in os.listdir(os.path.join(BENCHMARK_REPO, d))
          if os.path.isdir(os.path.join(BENCHMARK_REPO, d, x))]

factory = rl_experiment_factory.EcaiExperimentFactory()
exp = factory.create_ecai_experiment(
    search=rl_experiment_factory.TEMPLATE_ECAI_SEARCH,
    model_template=MODEL_TEMPLATE,
    model_template_values=MODEL_TEMPLATE_VALUES,
    model_directory=NN_MODELS,
    benchmark_repo=BENCHMARK_REPO,
    suites=SUITES,
    overall_time_limit=OVERALL_TIME_LIMIT,
    partition=PARTITION,
    unary_threshold=UNARY_THRESHOLD,
)

exp.run_steps()
