#! /usr/bin/env python

from __future__ import division
import logging
import json
import os

from lab.parser import Parser


FILE_STATISTICS = "samples_statistics.json"
KEY_FACT_FREQUENCIES = "fact_frequencies"
KEY_NB_SAMPLES = "nb_samples"


def parse_fact_frequencies(content, props):
    if os.path.isfile(FILE_STATISTICS):
        with open(FILE_STATISTICS, "r") as f:
            statistics = json.load(f)
        props[KEY_NB_SAMPLES] = statistics[KEY_NB_SAMPLES]
        props[KEY_FACT_FREQUENCIES] = statistics[KEY_FACT_FREQUENCIES]


if __name__ == "__main__":
    p = Parser()
    p.add_function(parse_fact_frequencies)
    p.parse()

