#! /usr/bin/env python

from __future__ import division
import logging
import numpy as np
import os

from lab.parser import Parser


SAMPLE_FILE = "samples.csv"


def parse_sample_file(content, props):
    if os.path.isfile(SAMPLE_FILE):
        ary = np.loadtxt(SAMPLE_FILE, delimiter=";", comments="#")
        props["h_samples"] = [list(x) for x in np.unique(ary[:, 0], return_counts=True)]

if __name__ == "__main__":
    p = Parser()
    p.add_function(parse_sample_file)
    p.parse()

