import os
import platform
import re

from downward.reports import Attribute, geometric_mean

""" Misc """
EMAIL_ADDRESS = "patrick.ferber@unibas.ch"
REPO = os.environ["DEEPDOWN"]
BENCHMARK_REPO = os.environ["DOWNWARD_BENCHMARKS"]
NODE = platform.node()
IS_REMOTE = (NODE.endswith(".scicore.unibas.ch") or
             NODE.endswith(".cluster.bc2.ch"))

""" Paths """
HOME = "/infai/ferber" if IS_REMOTE else "/home/ferber"
PATH_H2_PREPROCESSOR = os.path.join(HOME, "bin", "h2stable")
# Benchmark directory
DIR_BENCHMARKS_ECAI = "%s/repositories/benchmarks_ecai/" % HOME
DIR_VALIDATION_ECAI = "%s/repositories/benchmarks_validation/" % HOME
DIR_BENCHMARKS_ALT_INIT = "%s/repositories/benchmarks_alt_init/" % HOME
DIR_BENCHMARKS_REGRESSION = "%s/repositories/benchmarks_regression/" % HOME

# Path templates
PATH_TEMPLATE_EXP_ECAI = os.path.normpath(
    os.path.join(os.path.dirname(__file__), "..", "templates",
                 "template_ecai_experiment.py"))
PATH_TEMPLATE_EXP_ROBUSTNESS = os.path.normpath(
    os.path.join(os.path.dirname(__file__), "..", "templates",
                 "template_robustness_experiment.py"))
PATH_TEMPLATE_EXP_TRAINING = os.path.normpath(
    os.path.join(os.path.dirname(__file__), "..", "templates",
                 "template_training.py"))
PATH_TEMPLATE_EXP_VALIDATION_CYCLE = os.path.normpath(
    os.path.join(os.path.dirname(__file__), "..", "templates",
                 "template_validation_cycle.py"))
# Path to parsers
PATH_PARSER_LAST_EXPANSION = os.path.normpath(
    os.path.join(os.path.dirname(__file__), "last_expansions_parser.py"))
PATH_PARSER_TRAINING = os.path.normpath(
    os.path.join(os.path.dirname(__file__), "training_parser.py"))
PATH_PARSER_SAMPLING_DIVERSITY = os.path.normpath(
    os.path.join(os.path.dirname(__file__), "sampling_diversity_parser.py"))
PATH_PARSER_RW_DISTANCE = os.path.normpath(
    os.path.join(os.path.dirname(__file__), "rw_distance_parser.py"))

REGEX_BUILD_NAME = re.compile(r'^(release|debug)(32|64)?(dynamic)?$')


ATTRIBUTES_SEARCH = [
    "coverage", "search_time", "expansions", "plan_length", "initial_h_value",
    Attribute("last_logged_expansions", absolute=False, min_wins=True,
              functions=geometric_mean)
]
ATTRIBUTE_OVERLAP = Attribute("overlap_fraction", min_wins=False, digits=5,
                              scale="log")


ATTRIBUTES_NETWORK = [
    "final_epochs", "model_updates", "val_loss",
    "final_training_time", "average_waiting_time",
    "final_different_inputs", "final_different_predictions",
    "max_scrambles", "samples_generated", "samples_requested",
    "samples_req_gen_ratio",
]

ATTRIBUTES_INIT_SEARCH = [
    Attribute("init_coverage", absolute=True, min_wins=False, scale='linear'),
    Attribute("init_expansions", absolute=False, min_wins=True, scale='linear',
              functions=geometric_mean),
    Attribute("init_plan_length", absolute=False, min_wins=True, scale='linear')
]

ATTRIBUTES_INTER_SEARCHES = [
    Attribute("time_first_solution", absolute=False, min_wins=True, functions=geometric_mean),
    Attribute("total_coverage", absolute=True, min_wins=False, functions=sum),
    Attribute("sum_inter_coverages", absolute=False, min_wins=False, functions=geometric_mean)
]


# ECAI domains
DOMAIN_BLOCKSWORLD = "blocks"
DOMAIN_DEPOT = "depot"
DOMAIN_GRID = "grid"
DOMAIN_PIPESWORLD_NOTANKAGE = "pipesworld-notankage"
DOMAIN_SCANALYZER_OPT08_STRIPS = "scanalyzer-08-strips"
DOMAIN_SCANALYZER_OPT11_STRIPS = "scanalyzer-opt11-strips"
DOMAIN_STORAGE = "storage"
DOMAIN_TRANSPORT_OPT14_STRIPS = "transport-opt14-strips"
DOMAIN_NPUZZLE = "npuzzle"
DOMAIN_ROVERS = "rovers"
DOMAIN_VISITALL_OPT14_STRIPS = "visitall-opt14-strips"

ECAI_TASKS = {
    DOMAIN_BLOCKSWORLD: [
        'probBLOCKS-12-0.pddl', 'probBLOCKS-14-0.pddl', 'probBLOCKS-15-0.pddl',
        'probBLOCKS-15-1.pddl', 'probBLOCKS-16-1.pddl', 'probBLOCKS-17-0.pddl'],
    DOMAIN_DEPOT: ['p05.pddl', 'p08.pddl', 'p09.pddl', 'p10.pddl', 'p11.pddl',
    'p15.pddl', 'p16.pddl', 'p19.pddl', 'p21.pddl',],
    DOMAIN_GRID: ['prob03.pddl', 'prob04.pddl', 'prob05.pddl',],
    DOMAIN_PIPESWORLD_NOTANKAGE: ['p19-net2-b18-g6.pddl', 'p21-net3-b12-g2.pddl',
    'p24-net3-b14-g5.pddl', 'p27-net3-b18-g6.pddl',
    'p28-net3-b18-g7.pddl', 'p30-net3-b20-g8.pddl',
    'p31-net4-b14-g3.pddl', 'p32-net4-b14-g5.pddl',
    'p34-net4-b16-g6.pddl',
    'p41-net5-b22-g2.pddl',],
    DOMAIN_SCANALYZER_OPT08_STRIPS: ['p11.pddl', 'p12.pddl', 'p15.pddl',
    'p16.pddl', 'p18.pddl', 'p19.pddl',
    'p21.pddl', 'p27.pddl', 'p28.pddl',
    'p29.pddl', 'p30.pddl', 'p08.pddl',],
    DOMAIN_SCANALYZER_OPT11_STRIPS: ['p07.pddl', 'p10.pddl', 'p13.pddl',
    'p15.pddl', 'p16.pddl', 'p20.pddl',
    'p18.pddl', 'p19.pddl',],
    DOMAIN_STORAGE: ['p18.pddl'],
    DOMAIN_TRANSPORT_OPT14_STRIPS: ['p05.pddl', 'p10.pddl', 'p11.pddl', 'p12.pddl',
    'p16.pddl', 'p17.pddl', 'p18.pddl', 'p19.pddl',
    'p20.pddl',],
    DOMAIN_NPUZZLE: ['prob_n6_1.pddl', 'prob_n6_2.pddl', 'prob_n6_3.pddl', 'prob_n6_4.pddl', 'prob_n7_1.pddl', 'prob_n7_2.pddl', 'prob_n7_3.pddl', 'prob_n7_4.pddl'],
    DOMAIN_ROVERS: ['p11.pddl', 'p18.pddl', 'p20.pddl', 'p21.pddl', 'p22.pddl', 'p23.pddl', 'p26.pddl', 'p28.pddl', 'p29.pddl', 'p33.pddl'],
    DOMAIN_VISITALL_OPT14_STRIPS: ['p-1-12.pddl', 'p-1-13.pddl', 'p-1-14.pddl', 'p-1-15.pddl', 'p-1-16.pddl', 'p-1-17.pddl'],
}

for d, t in ECAI_TASKS.items():
    if t is None:
        continue
    for tt in t:
        assert os.path.isfile(os.path.join(BENCHMARK_REPO, d, tt)), (d, tt)

ECAI_TASK_SET = set([os.path.join(d, t)
                     for d, ts in ECAI_TASKS.items()
                     for t in ts])
# FURTHER1 DOMAINS
DOMAIN_AGRICOLA = "agricola-opt18-strips"
DOMAIN_DRIVERLOG = "driverlog"
# DOMAIN_ORGANIC_STNYHESIS = "organic-synthesis-opt18-strips"
DOMAIN_ORGANIC_STNYHESIS_SPLIT = "organic-synthesis-split-opt18-strips"
DOMAIN_PATHWAYS = "pathways"
DOMAIN_CHILDSNACK = "childsnack-opt14-strips"

FURTHER1_TASKS = {
    DOMAIN_AGRICOLA: None,
    DOMAIN_DRIVERLOG: None,
    # DOMAIN_ORGANIC_STNYHESIS: None,
    DOMAIN_ORGANIC_STNYHESIS_SPLIT: None,
    DOMAIN_PATHWAYS: None,
    DOMAIN_CHILDSNACK: None,
}


TASK_SELECTIONS = {
    "ecai": ECAI_TASKS,
    "further1": FURTHER1_TASKS,
}

ALL_DOMAINS_2019_10 = [
    DOMAIN_BLOCKSWORLD, DOMAIN_DEPOT, DOMAIN_GRID, DOMAIN_PIPESWORLD_NOTANKAGE,
    DOMAIN_SCANALYZER_OPT11_STRIPS, DOMAIN_STORAGE,
    DOMAIN_TRANSPORT_OPT14_STRIPS, DOMAIN_NPUZZLE, DOMAIN_ROVERS,
    DOMAIN_VISITALL_OPT14_STRIPS
]

FEWER_DOMAINS1 = [
    DOMAIN_BLOCKSWORLD, DOMAIN_GRID, DOMAIN_PIPESWORLD_NOTANKAGE,
    DOMAIN_NPUZZLE, DOMAIN_TRANSPORT_OPT14_STRIPS
]

