from . import rl_experiment_parsing

CONFIGURATIONS = {
    "BASE": "INIT-INTER-network_small-replay_replay-time_28h-buffer_100-mutex_trans",
    "BASENoRB": "INIT-INTER-network_smallNoRB-replay_replay-time_28h-buffer_100-mutex_trans",
    "SEARCH": "search_GBFS10-samptech_gbackward+S_5+UP_8_max~2-samptech_iforward+S300+A_after10h",
    "SEARCHReg": "search_GBFS10-samptech_gbackward+S_5+UP_8_max~2",
    "SEARCHX": "search_GBFS10X-samptech_gbackward+S_5+UP_8_max~2-samptech_iforward+S300+A_after10h",
    "SEARCHXReg": "search_GBFS10X-samptech_gbackward+S_5+UP_8_max~2",
    "AVI": "lookahead_2-samptech_gbackward+S_300",
    "BASETiny": "INIT-INTER-network_tiny-replay_replay-time_28h-buffer_100-mutex_trans",
}


def replace_base(cname):
    anker = rl_experiment_parsing.Ankers.INCLUDE.value
    includes = rl_experiment_parsing._get_anker(
        cname, anker, required=False, multiple=False)
    if includes is None:
        return cname

    replace_this = "%s%s" % (anker, includes)
    includes = includes.split("_")
    assert all(i in CONFIGURATIONS for i in includes)
    assert len(includes) == len(set(includes)), \
        "Do not include the same thing twice"
    replacement = "-".join(CONFIGURATIONS[i] for i in includes)
    return cname.replace(replace_this, replacement)
