#! /usr/bin/env python

from __future__ import division
import logging
import numpy as np

from lab.parser import Parser

import re

REGEX_FINAL_EXPANSIONS = re.compile(r"Expanded (\d+) state\(s\).")
REGEX_REGULAR_EXPANSIONS = re.compile(r", (\d+) expanded,")

def parse_final_expansions(content, props):
    expansions = REGEX_FINAL_EXPANSIONS.findall(content)
    assert len(expansions) <= 1
    if len(expansions) == 0:
        expansions = REGEX_REGULAR_EXPANSIONS.findall(content)
    expansions = None if len(expansions) == 0 else expansions[-1]
    props["last_logged_expansions"] = expansions

if __name__ == "__main__":
    p = Parser()
    p.add_function(parse_final_expansions)
    p.parse()

