#!/usr/bin/env python

import os
import platform
import sys

import rl_experiment

BUILD = "%s64dynamic" % ("release" if rl_experiment.IS_REMOTE else "debug")

NETWORK = "keras_mlp(tparams=ktparams(epoch_verbosity=100,rl_checkpoint=val_loss0.1,batch=250)," \
          "y_fields=0,x_fields=1,load=model,store=model," \
          "learner_formats=[pb,h5],hidden_layer_size=[250,250," \
          "keras_residual_block(hidden_layer_count=2,hidden_layer_size=250)," \
          "keras_residual_block(hidden_layer_count=2,hidden_layer_size=250)," \
          "keras_residual_block(hidden_layer_count=2,hidden_layer_size=250)," \
          "keras_residual_block(hidden_layer_count=2,hidden_layer_size=250)],"\
          "output_units=-1,batch_normalization=1)"

SUITES = [
    rl_experiment.DOMAIN_BLOCKSWORLD,
    #rl_experiment.DOMAIN_DEPOT,
    #rl_experiment.DOMAIN_GRID,
    rl_experiment.DOMAIN_PIPESWORLD_NOTANKAGE,
    rl_experiment.DOMAIN_SCANALYZER_OPT11_STRIPS,
    #rl_experiment.DOMAIN_STORAGE,
    rl_experiment.DOMAIN_TRANSPORT_OPT11_STRIPS,
    rl_experiment.DOMAIN_NPUZZLE,
    #rl_experiment.DOMAIN_ROVERS,
    #rl_experiment.DOMAIN_VISITALL_OPT11_STRIPS
]

exp = rl_experiment.get_base_experiment(suites=SUITES, cores=4)
rl_experiment.add_algorithm(
    exp, "base_rl", NETWORK,
    build_options=[BUILD],
    component_options=["--fast-downward-build", BUILD,
                       "--maximum-training-time", "8h",
                       "--increase-scrambling", "5"])

exp.run_steps()
