"""
Disables all external dependencies of this training framework (last time
updated  this was Tensorflow and Keras).
Therefore, it loads the dependency module w/o loading the whole package
(otherwise, changing the dependencies will have no effect anymore)
:return: None
"""
import os
import sys


def suppress_library_warnings(condition=True):
    stderr = None
    if condition:
        stderr = sys.stderr
        sys.stderr = open("/dev/null", "w")
    return stderr


def unsuppress_library_warnings(stderr):
    if stderr is not None:
        sys.stderr.close()
        sys.stderr = stderr


def disable():
    path_dependency_script = os.path.join(
        os.path.dirname(__file__),
        "src/training/dependencies.py")
    if sys.version_info >= (3, 5):
        import importlib.util
        spec = importlib.util.spec_from_file_location(
            "src.training.dependencies", path_dependency_script)
        dependencies = importlib.util.module_from_spec(spec)
        spec.loader.exec_module(dependencies)
        sys.modules["src.training.dependencies"] = dependencies
        dependencies.setup()
        dependencies.set_external(False, True)
    elif sys.version_info < (3,):
        import imp
        dependencies = imp.load_source("src.training.dependencies",
                                       path_dependency_script)
        sys.modules["src.training.dependencies"] = dependencies
        dependencies.setup()
        dependencies.set_external(False, True)
    else:
        print("Warning: Dependency pre-loading not supported by this python "
              "version. All dependencies are require.")


if __name__ == "__main__":
    print("Thou shall not call me directly.")
    assert False
