# Introduction

This folder contains scripts to pre-processe the collected data for further analyses. Output from these scripts is saved either in the database or in separate files (omitted for compliance with Twitter API guidelines and processed by the notebook in the `data` folder). 

# Instructions

## Daily Cron Job

The script `daily metric_job.py` needs to be executed as a daily cron job to fetch tweets from friends and followers of the drifters. Be sure to run this cron job during the time when the drifters are inactive (see the `activation_time` parameter in `bot/config_stats.py`) to avoid running into the Twitter API rate limit. 

## Compute valence score for each tweet

The script `compute_valence_scores.py` is to be run at the end of the experiment. It computes the url-based and hashtag-based political valence scores as well as the low-credibility counts for all tweets in the database and saves them in the database.

## Building ego networks

The script `generate_networks_for_each_bot.py` must be called at the end of the experiment to generate the ego networks for each drifter. The files generated by this script are used by the notebook in the `data` folder.

## Valence time series

The script `time_series_scores.py` is called by the notebook in the `data` folder to create the drifter time series.

Other scripts in this folder are utilities used by the above scripts.
