# Data Files

This folder contains:

1. All data files used to generate the final paper plots
1. Any external data used in the project
1. The [GenerateDataFiles.ipynb notebook](GenerateDataFiles.ipynb) extracts data from the project database and/or combine it with external data to generate the files for the final plots

*Note that all Tweet IDs and Twitter user IDs in the data files are masked.*

## Mapping

To run the [GenerateDataFiles.ipynb notebook](GenerateDataFiles.ipynb) you need to update the mapping between your drifters' real `screen_name` so the output files preserve their anonymity, and the mapping between bots and seeds. This should be performed at the beginning of the notebook in the variables `BOTS_RENAME` and `INIT_SEED_MAP`.

## Input data

+ ### Bot scores

In this project, we gathered data from [Botometer](https://botometer.iuni.iu.edu/) using the API. The input file for our analysis is [connections_seeds_unique_botscores.csv](connections_seeds_unique_botscores.csv). The base code to generate this file can be found in the [retrieving_botscore.ipynb](retrieving_botscore.ipynb) notebook.

+ ### Ego Networks

The [GenerateDataFiles.ipynb notebook](GenerateDataFiles.ipynb) computes the political valences and the echo chamber measurements, and generates [anonymized ego networks](/data/ego_networks/). However, it requires the de-anonymized versions generated by the independent script [metric/generate_networks_for_each_bot.py](/metric/generate_networks_for_each_bot.py). Once generated, you need to update the variable `GLOB_TO_EGO_NET` in the [GenerateDataFiles.ipynb notebook](GenerateDataFiles.ipynb) to point to these ego-networks. The de-anonymized data should stay private in compliance with Twitter's policy.
