#!/bin/bash
#PBS -A OPEN-12-52
#PBS -N nh_600k3
#PBS -q qprod
#PBS -l select=4:ncpus=24:mpiprocs=16:ompthreads=1
#PBS -l walltime=28:00:00
# #PBS -l place=group=ehc_2d

cat $PBS_NODEFILE
module load MPT/2.12
module load ifort/2015.3.187
module load icc/2015.3.187
module load imkl/11.2.3.187-iimpi-7.3.5
module rm iimpi/7.3.5 impi/5.0.3.048-iccifort-2015.3.187
export MPI_DSM_CPULIST=0,1,3,4,6,7,9,10,12,13,15,16,18,19,21,22:allhosts
VASP="mpiexec_mpt  /home/klimes/src/vasp/gk/mpt_no_shmem/single_MP2/bin/vasp_std"
export MKL_NUM_THREADS=1
export OMP_NUM_THREADS=1

cd $PBS_O_WORKDIR

mkdir  -p /scratch/work/user/klimes/$PBS_JOBID
SCRATCH=/scratch/work/user/klimes/$PBS_JOBID

cd $PBS_O_WORKDIR

cp cuts KPOINTS POSCAR POTCAR INCAR.*  $SCRATCH/

cd $SCRATCH

for icut in 1 #3 5 #1 2 3 4 5
 do
  line=`head -n $icut cuts | tail -n 1 `
  encut=`echo $line | awk '{print $1}' `
  encutgw=`echo $line | awk '{print $2}' `
  echo $encut $encutgw

NBANDS=4608
cp /scratch/work/user/klimes/8069939.isrv5/WAVECAR ./
cp /scratch/work/user/klimes/8069939.isrv5/WAVEDER ./

for KQMP2 in 25 26 27
 do
 for KIMP2 in 1 2 3 4
  do
  for KJMP2 in 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27
   do
cp INCAR.
cp INCAR.MP2 INCAR
echo "ENCUT=$encut" >> INCAR
echo "ENCUTGW=$encutgw" >> INCAR
echo "NBANDS=$NBANDS" >> INCAR
echo "KQMP2=$KQMP2" >> INCAR
echo "KIMP2=$KIMP2" >> INCAR
echo "KJMP2=$KJMP2" >> INCAR
$VASP > out.MP2.$encut.${encutgw}.${KQMP2}.${KIMP2}.${KJMP2}
cp OUTCAR OUTCAR.MP2.$encut.${encutgw}.${KQMP2}.${KIMP2}.${KJMP2}
cp OUTCAR.MP2.$encut.${encutgw}.${KQMP2}.${KIMP2}.${KJMP2} $PBS_O_WORKDIR/
#cp out.MP2.$encut.${encutgw}.${KQMP2}.${KIMP2}.${KJMP2} $PBS_O_WORKDIR/
  done
 done
done

  rm CHG* WAVE*
 done


