#!/bin/bash
#PBS -A OPEN-9-18
#PBS -N meo_221
#PBS -q qprod
#PBS -l walltime=12:00:00
#PBS -l select=1:ncpus=24:mpiprocs=16:ompthreads=1
#PBS -l place=group=ehc_1d

module load MPT/2.12
module load ifort/2015.3.187
module load icc/2015.3.187
module load imkl/11.2.3.187-iimpi-7.3.5
module rm iimpi/7.3.5 impi/5.0.3.048-iccifort-2015.3.187

VASP="mpiexec_mpt  /home/klimes/src/vasp/gk/mpt_no_shmem/bin/vasp_std"
export MKL_NUM_THREADS=1

mkdir  -p /scratch/work/user/klimes/$PBS_JOBID
SCRATCH=/scratch/work/user/klimes/$PBS_JOBID

cd $PBS_O_WORKDIR

cp cuts KPOINTS POSCAR POTCAR INCAR.*  $SCRATCH/

cd $SCRATCH

##################################

for icut in   6 7 1 2 3 4 5 
 do
  line=`head -n $icut cuts | tail -n 1 `
  encut=`echo $line | awk '{print $1}' `
  encutgw=`echo $line | awk '{print $2}' `
  echo $encut $encutgw

cp INCAR.dft INCAR
echo "ENCUT=$encut" >> INCAR
$VASP
cp OUTCAR OUTCAR.dft.$encut.$len
cp OUTCAR.dft.$encut.$len $PBS_O_WORKDIR/

cp INCAR.hf INCAR
echo "ENCUT=$encut" >> INCAR
echo "HFRCUT=-1" >> INCAR
$VASP
cp OUTCAR OUTCAR.HF.$encut.$len
cp OUTCAR.HF.$encut.$len $PBS_O_WORKDIR/


#------------------------------------------------------------------------------------

  rm WAVECAR WAVEDER CHG*
 done

#####################################

cp $SCRATCH/OUTCAR* $PBS_O_WORKDIR
cp $SCRATCH/out* $PBS_O_WORKDIR


