#!/bin/bash
#PBS -A OPEN-12-52
#PBS -N me_mp2
#PBS -q qprod
#PBS -l select=4:ncpus=24:mpiprocs=16:ompthreads=1
#PBS -l walltime=18:00:00
#PBS -l place=group=ehc_2d

cat $PBS_NODEFILE
module load MPT/2.12
module load ifort/2015.3.187
module load icc/2015.3.187
module load imkl/11.2.3.187-iimpi-7.3.5
module rm iimpi/7.3.5 impi/5.0.3.048-iccifort-2015.3.187
export MPI_DSM_CPULIST=0,1,3,4,6,7,9,10,12,13,15,16,18,19,21,22:allhosts
VASP="mpiexec_mpt  /home/klimes/src/vasp/gk/mpt_no_shmem/bin/vasp_gam"
export MKL_NUM_THREADS=1
export OMP_NUM_THREADS=1

cd $PBS_O_WORKDIR

mkdir  -p /scratch/work/user/klimes/$PBS_JOBID
SCRATCH=/scratch/work/user/klimes/$PBS_JOBID

cd $PBS_O_WORKDIR

cp cuts KPOINTS POSCAR POTCAR INCAR.*  $SCRATCH/

cd $SCRATCH

for icut in 1 2 3 4 5 6 7 8 9  #3 5 #1 2 4 #3 5 #1 2 3 4 5
 do
  line=`head -n $icut cuts | tail -n 1 `
  encut=`echo $line | awk '{print $1}' `
  encutgw=`echo $line | awk '{print $2}' `
  echo $encut $encutgw

cp INCAR.dft INCAR
echo "ENCUT=$encut" >> INCAR
$VASP
cp OUTCAR OUTCAR.dft.$encut
cp OUTCAR.dft.$encut $PBS_O_WORKDIR/

cp INCAR.HF INCAR
echo "ENCUT=$encut" >> INCAR
$VASP
cp OUTCAR OUTCAR.HF.$encut
cp OUTCAR.HF.$encut $PBS_O_WORKDIR/

numcpu=64
gfac=2  #2 for gamma, 1 for std k-pt sets
NBANDS__=`grep -m 1 "maximum number" OUTCAR | cut -c 35- | tr -d " " `
NBANDS_=`echo "$NBANDS__ * $gfac / $numcpu + 1" | bc`
NBANDS=`echo "$NBANDS_* $numcpu" | bc `

cp INCAR.HF.exact INCAR
echo "ENCUT=$encut" >> INCAR
echo "NBANDS=$NBANDS" >> INCAR
$VASP
cp OUTCAR OUTCAR.HF.diag.$encut
cp OUTCAR.HF.diag.$encut $PBS_O_WORKDIR/

cp INCAR.MP2 INCAR
echo "ENCUT=$encut" >> INCAR
echo "ENCUTGW=$encutgw" >> INCAR
echo "NBANDS=$NBANDS" >> INCAR
$VASP > out.MP2.$encut.${encutgw}
cp OUTCAR OUTCAR.MP2.$encut.${encutgw}
cp OUTCAR.MP2.$encut.${encutgw} $PBS_O_WORKDIR/
cp out.MP2.$encut.${encutgw} $PBS_O_WORKDIR/

  rm WAVE*  CHG*
 done


