#!/bin/bash
#PBS -A OPEN-22-14
#PBS -N co2_k4dMP
#PBS -q qprod
#PBS -l select=32:ncpus=24:mpiprocs=8:ompthreads=1
#PBS -l walltime=48:00:00

module load intel/2020b
#VASP="mpiexec.hydra /home/klimes/src/vasp/HSE_patches/clean/vasp.5.4.4/intel_2018.04/bin/vasp_gam"
VASP="mpiexec.hydra /home/klimes/src/vasp/gk/mpt_no_shmem/single_mp2_intel_2020b/bin/vasp_std"
VASP64="mpiexec.hydra -np 64 /home/klimes/src/vasp/gk/mpt_no_shmem/single_mp2_intel_2020b/bin/vasp_std"

export MKL_NUM_THREADS=1
export OMP_NUM_THREADS=1

mkdir  -p /scratch/temp/user/klimes/$PBS_JOBID
SCRATCH=/scratch/temp/user/klimes/$PBS_JOBID

cd $PBS_O_WORKDIR

cp cuts KPOINTS POSCAR POTCAR INCAR.*  $SCRATCH/

cd $SCRATCH

for icut in 5
 do
  line=`head -n $icut cuts | tail -n 1 `
  encut=`echo $line | awk '{print $1}' `
  encutgw=`echo $line | awk '{print $2}' `
  echo $encut $encutgw

NBANDS=13056

cp /scratch/temp/user/klimes/10543248.isrv5/WAVECAR .
cp /scratch/temp/user/klimes/10543248.isrv5/WAVEDER .

cp INCAR.dMP2 INCAR
echo "ENCUT=$encut" >> INCAR
echo "ENCUTGW=$encutgw" >> INCAR
echo "NBANDS=$NBANDS" >> INCAR
$VASP > out.dMP2.$encut.${encutgw}
cp OUTCAR OUTCAR.dMP2.$encut.${encutgw}
cp OUTCAR.dMP2.$encut.${encutgw} $PBS_O_WORKDIR/
cp out.dMP2.$encut.${encutgw} $PBS_O_WORKDIR/

  #rm WAVE*  CHG*
 done

