#!/bin/bash
#PBS -A OPEN-20-35
#PBS -N co2_mp2_2k700
#PBS -q qlong
#PBS -l select=16:ncpus=24:mpiprocs=16:ompthreads=1
#PBS -l walltime=144:00:00

module load intel/2020b
#VASP="mpiexec.hydra /home/klimes/src/vasp/HSE_patches/clean/vasp.5.4.4/intel_2018.04/bin/vasp_gam"
VASP="mpiexec.hydra /home/klimes/src/vasp/gk/mpt_no_shmem/single_mp2_intel_2020b/bin/vasp_std"

export MKL_NUM_THREADS=1
export OMP_NUM_THREADS=1

mkdir  -p /scratch/temp/user/klimes/$PBS_JOBID
SCRATCH=/scratch/temp/user/klimes/$PBS_JOBID

cd $PBS_O_WORKDIR

cp cuts KPOINTS POSCAR POTCAR INCAR.*  $SCRATCH/

cd $SCRATCH

for icut in 2 #3 5 #1 2 3 4 5
 do
  line=`head -n $icut cuts | tail -n 1 `
  encut=`echo $line | awk '{print $1}' `
  encutgw=`echo $line | awk '{print $2}' `
  echo $encut $encutgw

NBANDS=7680
cp /scratch/temp/user/klimes/10524017.isrv5/WAVECAR ./
cp /scratch/temp/user/klimes/10524017.isrv5/WAVEDER ./

cp INCAR.MP2 INCAR
echo "ENCUT=$encut" >> INCAR
echo "ENCUTGW=$encutgw" >> INCAR
echo "NBANDS=$NBANDS" >> INCAR
$VASP > out.MP2.$encut.${encutgw}
cp OUTCAR OUTCAR.MP2.$encut.${encutgw}
cp OUTCAR.MP2.$encut.${encutgw} $PBS_O_WORKDIR/
cp out.MP2.$encut.${encutgw} $PBS_O_WORKDIR/

  rm CHG* WAVE*
 done


