#!/bin/bash
#PBS -A OPEN-22-14
#PBS -N co2_mp2k2loop
#PBS -q qprod
#PBS -l select=8:ncpus=24:mpiprocs=16:ompthreads=1
#PBS -l walltime=48:00:00

module load intel/2020b
#VASP="mpiexec.hydra /home/klimes/src/vasp/HSE_patches/clean/vasp.5.4.4/intel_2018.04/bin/vasp_gam"
VASP="mpiexec.hydra /home/klimes/src/vasp/gk/mpt_no_shmem/single_mp2_intel_2020b/bin/vasp_std"

export MKL_NUM_THREADS=1
export OMP_NUM_THREADS=1

mkdir  -p /scratch/temp/user/klimes/$PBS_JOBID
SCRATCH=/scratch/temp/user/klimes/$PBS_JOBID

cd $PBS_O_WORKDIR

cp cuts KPOINTS POSCAR POTCAR INCAR.*  $SCRATCH/

cd $SCRATCH

for icut in 9
 do
  line=`head -n $icut cuts | tail -n 1 `
  encut=`echo $line | awk '{print $1}' `
  encutgw=`echo $line | awk '{print $2}' `
  echo $encut $encutgw

NBANDS=21504
cp /scratch/temp/user/klimes/10538102.isrv5/WAVECAR ./
cp /scratch/temp/user/klimes/10538102.isrv5/WAVEDER ./

for KQMP2 in 3
 do
 for KIMP2 in 1 2 
  do
  for KJMP2 in 1 2 3 4 
   do
cp INCAR.MP2 INCAR
echo "ENCUT=$encut" >> INCAR
echo "ENCUTGW=$encutgw" >> INCAR
echo "NBANDS=$NBANDS" >> INCAR
echo "KQMP2=$KQMP2" >> INCAR
echo "KIMP2=$KIMP2" >> INCAR
echo "KJMP2=$KJMP2" >> INCAR
$VASP > out.MP2.$encut.${encutgw}.${KQMP2}.${KIMP2}.${KJMP2}
cp OUTCAR OUTCAR.MP2.$encut.${encutgw}.${KQMP2}.${KIMP2}.${KJMP2}
cp OUTCAR.MP2.$encut.${encutgw}.${KQMP2}.${KIMP2}.${KJMP2} $PBS_O_WORKDIR/
#cp out.MP2.$encut.${encutgw}.${KQMP2}.${KIMP2}.${KJMP2} $PBS_O_WORKDIR/
  done
 done
done

  rm CHG* WAVE*
 done


