#!/bin/bash
#PBS -A OPEN-22-14
#PBS -N co2_4k
#PBS -q qprod
#PBS -l select=8:ncpus=24:mpiprocs=16:ompthreads=1
#PBS -l walltime=48:00:00
#PBS -l place=group=ehc_1d

module load intel/2020b
#VASP="mpiexec.hydra /home/klimes/src/vasp/HSE_patches/clean/vasp.5.4.4/intel_2018.04/bin/vasp_gam"
VASP="mpiexec.hydra /home/klimes/src/vasp/gk/mpt_no_shmem/single_mp2_intel_2020b/bin/vasp_std"
VASP64="mpiexec.hydra -np 64 /home/klimes/src/vasp/gk/mpt_no_shmem/single_mp2_intel_2020b/bin/vasp_std"


export MKL_NUM_THREADS=1
export OMP_NUM_THREADS=1

mkdir  -p /scratch/temp/user/klimes/$PBS_JOBID
SCRATCH=/scratch/temp/user/klimes/$PBS_JOBID

cd $PBS_O_WORKDIR

cp cuts KPOINTS POSCAR POTCAR INCAR.*  $SCRATCH/

cd $SCRATCH

for icut in 7
 do
  line=`head -n $icut cuts | tail -n 1 `
  encut=`echo $line | awk '{print $1}' `
  encutgw=`echo $line | awk '{print $2}' `
  echo $encut $encutgw

cp INCAR.dft INCAR
echo "ENCUT=$encut" >> INCAR
$VASP64
cp OUTCAR OUTCAR.dft.$encut
cp OUTCAR.dft.$encut $PBS_O_WORKDIR/

cp INCAR.HF INCAR
echo "ENCUT=$encut" >> INCAR
$VASP64
cp OUTCAR OUTCAR.HF.HFRCUT.$encut
cp OUTCAR.HF.HFRCUT.$encut $PBS_O_WORKDIR/

numcpu=512
gfac=1  #2 for gamma, 1 for std k-pt sets
NBANDS__=`grep -m 1 "maximum number" OUTCAR | cut -c 35- | tr -d " " `
NBANDS_=`echo "$NBANDS__ * $gfac / $numcpu + 1" | bc`
NBANDS=`echo "$NBANDS_* $numcpu" | bc `

cp INCAR.HF.exact INCAR
echo "ENCUT=$encut" >> INCAR
echo "NBANDS=$NBANDS" >> INCAR
$VASP
cp OUTCAR OUTCAR.HF.HFRCUT.diag.$encut
cp OUTCAR.HF.HFRCUT.diag.$encut $PBS_O_WORKDIR/

KQMP2=1
KIMP2=1
KJMP2=1

cp INCAR.MP2 INCAR
echo "ENCUT=$encut" >> INCAR
echo "ENCUTGW=$encutgw" >> INCAR
echo "NBANDS=$NBANDS" >> INCAR
echo "KQMP2=${KQMP2}" >> INCAR
echo "KIMP2=${KIMP2}" >> INCAR
echo "KJMP2=${KJMP2}" >> INCAR
$VASP > out.MP2.$encut.${encutgw}.${KQMP2}.${KIMP2}.${KJMP2}
cp OUTCAR OUTCAR.MP2.$encut.${encutgw}.${KQMP2}.${KIMP2}.${KJMP2}
cp OUTCAR.MP2.$encut.${encutgw}.${KQMP2}.${KIMP2}.${KJMP2} $PBS_O_WORKDIR/

  #rm WAVE*  CHG*
 done

