#!/opt/apes/miniconda3/bin/python
  
##############################################################
## generate the tetramers according to a distance criterion ##
##############################################################

import mbe
import numpy as np
import os
import importlib; importlib.reload(mbe)

#read the unit cell
cell=mbe.read_cell('../../input/cell')

#load the monomers
coord, elems=mbe.read_monomers_uni('../../input')

#print(coord)

#read the monomer list, i.e. the list with 
#index shell x y z nmono
#mlist=mbe.read_list('list_8787.dat')

#alternatively, generate the list of monomers on the fly
#each item holds: index shell x y z nmono
#indices start from 0 for the 0 0 0 0 0 molecule
mlist=mbe.gen_list(6,4)
print(elems)

merlist=[]
merlist.append(0)
merlist.append(2)
merlist.append(82)
mbe.get_chematrix(merlist,mlist,coord,elems,cell)

merlist=[]
merlist.append(0)
merlist.append(9)
merlist.append(20)
mbe.get_chematrix(merlist,mlist,coord,elems,cell)

merlist=[]
merlist.append(0)
merlist.append(9)
merlist.append(81)
print (merlist)
mbe.get_chematrix(merlist,mlist,coord,elems,cell)
