#!/opt/apes/miniconda3/bin/python
  
##############################################################
## generate the tetramers according to a distance criterion ##
##############################################################

import mbe
import numpy as np
import os
import importlib; importlib.reload(mbe)

#read the unit cell
cell=mbe.read_cell('../../input/cell')

#load the monomers
coord, elems=mbe.read_monomers_uni('../../input')

#print(coord)

#read the monomer list, i.e. the list with 
#index shell x y z nmono
#mlist=mbe.read_list('list_8787.dat')

#alternatively, generate the list of monomers on the fly
#each item holds: index shell x y z nmono
#indices start from 0 for the 0 0 0 0 0 molecule
mlist=mbe.gen_list(6,4)

with open('test_list_500_36.dat','r') as f:
  flin=f.readlines()

#the list is ordered according to distance,
#so for all mers with the same distance we will 
#build a list of inequivalent mers. First, put the first into inequiv list
#compare the next ones to those in the list, if equivalent, then say so,
#if inequiv, add them to list
#clear everything if the distance changes by more than epsilon
idx=0
dist_cur=-1
epsilon=1.e-6
inequiv=[] 
eig_list=[]
neq_list=[]
for line in range(len(flin)):
  fspl=flin[line].split()
  #get directories, delete final slash as it otherwise creates 
  #an empty element at the end of dirs
  dirs=fspl[0].strip('/').split('/')
  idxs=[]
  #TODO this does not work since there is one empty element at the end of the list
  #can be empty element easily removed?
  for i in range(len(dirs)):
     #for i in range(4):
     #print(dirs[i])
     idxs.append(mbe.get_idx_str(mlist,dirs[i]))
  #get distance
  dist=float(fspl[4])

  #check the distance
  if abs(dist-dist_cur) > epsilon:
     #print('new distance'+str(dist))
     #print('Register new inequivalent mer ', str(idxs))
     #we moved to a new set of mers
     #clear the inequiv list of mers and their chematrix eigenvalues
     for inmer in range(len(inequiv)):
        print ('Found '+str(neq_list[inmer])+' equivalent mers for '+str(inequiv[inmer]))
     inequiv=[] 
     eig_list=[]
     neq_list=[]
     #add the current mer as the first element
     inequiv.append(idxs)
     #we have now one equivalent mer for the new mer
     neq_list.append(1)
     #get the chematrix eigenvalues and add them to list 
     eigvals=mbe.get_chematrix(idxs,mlist,coord,elems,cell)
     eig_list.append(eigvals)
     #print('mer')
     #print(inequiv)
     #print(eig_list)
     dist_cur=dist
  else:
     #the distance has not changed
     #we have possibly an inequivalent or equivalent mer
     #get the current eigenvals and compare them to those in the inequiv list
     eigvals=mbe.get_chematrix(idxs,mlist,coord,elems,cell)
     #go through the list of inequivalent mers 
     #assume that the mer is inequivalent
     new=1
     for inmer in range(len(inequiv)):
        #print(inmer) 
        #print(eigvals)
        #print(eig_list[inmer])
        #print(eigvals-eig_list[inmer])
        tot=np.sum(np.absolute(eigvals-eig_list[inmer]))
        #print(tot)
        if tot < epsilon:
           #we have a mer equivalent to inmer
           #print(str(idx)+' found equivalent to '+str(inequiv[inmer]))
           new=0
           equiv=inmer
           neq_list[inmer]+=1
     #we have really a new inequivalent mer
     #store its eigenvalues and indices
     if new==1:
        #print('Found new inequivalent mer ', str(idxs))
        inequiv.append(idxs)
        eig_list.append(eigvals)
        neq_list.append(1)
  
  #fdirs=fspl[0].split('/')
  #merlist=[]
  #merlist.append(mbe.get_idx_str(mlist,fdirs[0]))
  #merlist.append(mbe.get_idx_str(mlist,fdirs[1]))
  #merlist.append(mbe.get_idx_str(mlist,fdirs[2]))
  #merlist.append(mbe.get_idx_str(mlist,fdirs[3]))
  #mbe.get_chematrix(merlist,mlist,coord,elems,cell)
  
  idx+=1
  if idx>1000:
    break
  



merlist=[]
merlist.append(0)
merlist.append(1)
merlist.append(2)
merlist.append(3)
mbe.get_chematrix(merlist,mlist,coord,elems,cell)

merlist=[]
merlist.append(0)
merlist.append(1)
merlist.append(102)
merlist.append(103)
mbe.get_chematrix(merlist,mlist,coord,elems,cell)

merlist=[]
merlist.append(0)
merlist.append(2)
merlist.append(21)
merlist.append(23)
#print (merlist)
mbe.get_chematrix(merlist,mlist,coord,elems,cell)
