#!/opt/apes/miniconda3/bin/python

#in this script we create the todo list 

import os
import mbe
import importlib; importlib.reload(mbe)

##read the unit cell
#cell=mbe.read_cell('../input/cell')

#load the monomers
#coord, elems=mbe.read_monomers_uni('../input')

#read the list of dimers
with open('dist_generate_py/sym_sort_shell6_ref0.dat') as f:
   calc_all=f.readlines()

#with open('../input/new_tail.init.sh') as ftail:
#   tail=ftail.readlines()

#with open('../input/new_head.init.sh') as fhead:
#   head=fhead.readlines()

basis='CC_AVTZ'
#quality='test_10tig'
quality='test20tig'

idx=0
#loop over trimers
for calc_line in calc_all:
   #print(idx)
   calc_dir=calc_line.split()[0]
   dist=calc_line.split()[1]
   if not os.path.isdir(calc_dir+'/'+quality+'_'+basis):
      print('directory does not exist, exiting ',+calc_dir+'/'+quality+'_'+basis)
      exit()
   #if the input file does not exist
   if os.path.isfile(calc_dir+'/'+quality+'_'+basis+'/getmp2.com'):
      #if the structure is not calculated
      if not os.path.isfile(calc_dir+'/'+quality+'_'+basis+'/DONE'):
         print(calc_dir+'/'+quality+'_'+basis+'/ TODO '+str(dist)+' ' +str(idx))
   else:  
      print('No input found in '+calc_dir+'/'+quality+'_'+basis)
      exit()
  

