#!/opt/apes/miniconda3/bin/python
import os
import mbe
import importlib; importlib.reload(mbe)

#function to get the four body energies
basis='AVDZ_AVQZfit'
quality='test20tig'

#file listing the tetramers and their energies
reffile="energies_box_sym_shell3_40_"+quality+"_"+basis+".dat"

#now the datafile does not exist, create it first
#!!! IF THE FILE EXISTS BUT IS EMPTY OR WRONG, YOU HAVE TO DELETE IT YOURSELF !!!
if os.path.isfile(reffile) == False:
   with open(reffile,'w+') as en:
      #do we have a file to copy some data from? (larger cut-offs, box vs len generate)
      #NO at this point
      #so we simply read the list and add TODO and zeros to the lines and write them 
      #read the list of the -mers
      with open('box_generate_py/sym_sort_list_shell3_40.dat','r') as f:
      #with open('box_generate_py/list_15.dat','r') as f:
         listline=f.readlines()
         for line in listline:
            direct=line.split()[0]
            dists=line.split()[1:]
            #write the directory including the basis, tag, distances, and the energies line by line
            en.write(direct+'/'+quality+'_'+basis+'/ TODO '+' '.join(map(str,dists)) +' 0.0 0.0 0.0 0.0\n')

#read the datafile, it should exist now
if os.path.isfile(reffile) == True:
   with open(reffile,'r') as en:
      dataline=en.readlines()

#now go through the lines and add new data
idx=0
#a new file, could be also stored in memory and written at the end I suppose
newref='new_energies_box_sym_shell3_40_'+quality+'_'+basis+'.dat'
#newref='new_box15_py_test10tig_AVTZ.dat'
with open(newref,'w+') as new:
   for line in dataline:
      #check first if we have the data already
      havedata=line.split()[1]
      #we have data, copy the line from the original file
      if havedata=='DONE':
         new.write(line)
      else:
         #we are in TODO state, this can mean that the job does not exist yet, it is running
         #it has crashed, or it has finished
         direct=line.split()[0]
         dists=line.split()[2:7] #copy distances and symmetry factor
         if os.path.isfile(direct+'/getmp2.out') == True:
            #read the output into memory
            with open(direct+'/getmp2.out') as output:
                outline=output.readlines()
            #check if the output ends with the correct line
            if 'Molpro calculation terminated' in outline[-1]:
               #process file
               print('attempt ', direct)
               energies=mbe.get_HF_MP2_Molpro(outline,4)
               if energies[0]==True:
                  #the energies were sucessfully obtained
                  new.write(direct+'/ DONE '+' '.join(map(str,dists))+' '+' '.join(map(str,energies[1:])) +'\n')
               else:
                  #there is some issue with the file, copy the TODO
                  new.write(line)
            else:
               #the job has crashed copy the line from input (with TODO)
               #print ('Error: job not sucessfull '+direct)
               new.write(line)
         else:
            #file does not exist, copy the line from the input (it should contain TODO)
            #print ('Error: file does not exist '+direct)
            new.write(line)

