#!/opt/apes/miniconda3/bin/python

#in this script we create the input files for molpro

import os
import mbe
import importlib; importlib.reload(mbe)

##read the unit cell
#cell=mbe.read_cell('../input/cell')

#load the monomers
#coord, elems=mbe.read_monomers_uni('../input')

quality='test20tig'
basis='CCc_AVTZ'
basis_short='AVTZ'

#read the list of trimers
with open('dist_generate_py/sym_list_shell6_40.dat') as f:
   calc_all=f.readlines()

with open('../input/'+quality+'_'+basis+'_trimer.tail') as ftail:
   tail=ftail.readlines()

idx=0
#loop over trimers
for calc_line in calc_all:
   print(idx)
   calc_dir=calc_line.split()[0]
   if not os.path.isdir(calc_dir+'/'+quality+'_'+basis):
      os.mkdir(calc_dir+'/'+quality+'_'+basis)
   #if the input file does not exist
   #if not os.path.isfile(calc_dir+'/'+quality+'_'+basis+'/getmp2.com'):
      #if the structure exists
      if os.path.isfile(calc_dir+'/trimer.xyz'):
          #read the tetramer structure
          with open(calc_dir+'/trimer.xyz') as fstruc:
             struc=fstruc.readlines()
          #write the input file (can be done in a nicer way
          with open(calc_dir+'/'+quality+'_'+basis+'/getmp2.com','w+') as fout:
             print('make file')
             fout.write('memory,900,m;\n') 
             fout.write('NOSYM\n')
             fout.write('geometry={\n')
             for line in struc:
                fout.write(line)
             fout.write('}\n')
             fout.write('basis='+basis_short+'\n')
             #fout.write('gdirect\n')
             for line in tail:
                fout.write(line)
      else:  
         print(calc_dir)
         print('No trimer structure found, please check your list or run gen_trim.py first')
         exit()
  
   idx+=1
 #  if idx>10:
 #     break

