#!/opt/apes/miniconda3/bin/python

##############################################################
## generate the trimers according to a distance criterion ##
##############################################################

import mbe
import numpy as np
import os
import importlib; importlib.reload(mbe)

#read the unit cell from a file called cell
cell=mbe.read_cell('../../input/cell')

#load the monomers
#from files called 0.tail ... 3.tail
coord, elems=mbe.read_monomers_uni('../../input')

#print(coord)

#read the monomer list, i.e. the list with 
#index shell x y z nmono
#mlist=mbe.read_list('list_8787.dat')

#alternatively, generate the list of monomers on the fly
#each item holds: index shell x y z nmono
#indices start from 0 for the 0 0 0 0 0 molecule
#the first argument is number of cells, the second is number of monomers 
mlist=mbe.gen_list(6,coord.shape[0])

#mbe.get_distance_from_idx(0,4,mlist,coord,cell)

#with all this generating the distances is as simple as this
#id0=0
#for id1 in range(1,500):
#   dist01=mbe.get_distance_from_idx(id0,id1,mlist,coord,cell)
#   for id2 in range(id1+1,500):
#      dist02=mbe.get_distance_from_idx(id0,id2,mlist,coord,cell)
#      dist12=mbe.get_distance_from_idx(id1,id2,mlist,coord,cell)
#      for id3 in range(id1+1,500):
#         dist03=mbe.get_distance_from_idx(id0,id3,mlist,coord,cell)
#         dist13=mbe.get_distance_from_idx(id1,id3,mlist,coord,cell)
#         dist23=mbe.get_distance_from_idx(id2,id3,mlist,coord,cell)
#         tot_dist=dist01+dist02+dist12+dist03+dist13+dist23
#         if tot_dist<=20.0:
#            print(tot_dist,mbe.get_vec(id1,mlist),mbe.get_vec(id2,mlist))

#mbe.gen_tetramers(50,25.,mlist,coord,cell,'list_500_36.dat')
#mbe.gen_tetramers(500,36.,mlist,coord,cell,'list_500_36.dat')
mbe.gen_trimers_dist_cache_cell(6,50.,mlist,coord,cell,'list_shell6_50.dat')





